/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.blockentity;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.XKDeco;
import org.teacon.xkdeco.blockentity.SingleSlotContainerBlockEntity;
import org.teacon.xkdeco.init.XKDecoEntityTypes;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class BlockDisplayBlockEntity
extends SingleSlotContainerBlockEntity {
    private static final String BLOCK_STATE_KEY = "BlockState";
    private static final String SELECTED_PROPERTY_KEY = "SelectedProperty";
    private static final BlockState EMPTY = Blocks.f_50016_.m_49966_();
    private BlockState blockState = EMPTY;
    @Nullable
    private Property<?> selectedProperty = null;

    public BlockDisplayBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)XKDecoEntityTypes.BLOCK_DISPLAY.getOrCreate(), pWorldPosition, pBlockState);
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)this.m_58899_().m_7494_()));
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pStack.m_41720_() instanceof BlockItem;
    }

    @Override
    public void m_6836_(int pSlot, ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setStoredBlockState(blockItem.m_40614_().m_49966_());
        } else {
            this.setStoredBlockState(EMPTY);
        }
        super.m_6836_(pSlot, pStack);
    }

    public BlockState getStoredBlockState() {
        return this.blockState;
    }

    public void setStoredBlockState(BlockState blockState) {
        this.blockState = blockState;
        this.getSelectedProperty();
        this.refresh();
    }

    @Nullable
    public Property<?> getSelectedProperty() {
        if (this.blockState != EMPTY && this.selectedProperty == null) {
            Collection properties = this.blockState.m_61147_();
            this.selectedProperty = properties.isEmpty() ? null : (Property)properties.iterator().next();
        }
        return this.selectedProperty;
    }

    public void setSelectedProperty(@Nullable Property<?> selectedProperty) {
        this.selectedProperty = selectedProperty;
        this.m_6596_();
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        super.readPacketData(pTag);
        this.readPacketData(pTag);
        if (pTag.m_128441_(SELECTED_PROPERTY_KEY)) {
            try {
                this.selectedProperty = KBlockUtils.getProperty((BlockState)this.blockState, (String)pTag.m_128461_(SELECTED_PROPERTY_KEY));
            }
            catch (Exception e) {
                XKDeco.LOGGER.error("", (Throwable)e);
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        super.writePacketData(pTag);
        this.writePacketData(pTag);
        if (this.selectedProperty != null) {
            pTag.m_128359_(SELECTED_PROPERTY_KEY, this.selectedProperty.m_61708_());
        }
    }

    @Override
    protected void readPacketData(CompoundTag pTag) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)pTag.m_128469_(BLOCK_STATE_KEY));
    }

    @Override
    protected CompoundTag writePacketData(CompoundTag pTag) {
        pTag.m_128365_(BLOCK_STATE_KEY, (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        return pTag;
    }
}

