/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.teacon.xkdeco.block.ItemDisplayBlock;
import org.teacon.xkdeco.blockentity.SingleSlotContainerBlockEntity;
import org.teacon.xkdeco.init.XKDecoEntityTypes;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ItemDisplayBlockEntity
extends SingleSlotContainerBlockEntity {
    public static final String SPIN_KEY = "FixedSpin";
    private float fixedSpin;

    public ItemDisplayBlockEntity(BlockPos blockPos, BlockState blockState, boolean projector) {
        super(projector ? (BlockEntityType)XKDecoEntityTypes.ITEM_PROJECTOR.getOrCreate() : (BlockEntityType)XKDecoEntityTypes.ITEM_DISPLAY.getOrCreate(), blockPos, blockState);
    }

    public AABB getRenderBoundingBox() {
        if (this.isProjector()) {
            return AABB.m_165882_((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_().m_6630_(9)), (double)16.0, (double)16.0, (double)16.0);
        }
        return AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)this.m_58899_().m_7494_()));
    }

    public boolean isProjector() {
        return XKDecoEntityTypes.ITEM_PROJECTOR.is((Object)this.m_58903_());
    }

    public float getSpin() {
        if (this.hasFixedSpin()) {
            return this.fixedSpin;
        }
        return this.f_58857_ == null ? 0.0f : (float)this.f_58857_.m_46467_();
    }

    public boolean hasFixedSpin() {
        return (Boolean)this.m_58900_().m_61143_((Property)ItemDisplayBlock.POWERED);
    }

    public void setFixedSpin(float fixedSpin) {
        this.fixedSpin = fixedSpin;
    }

    @Override
    protected void readPacketData(CompoundTag pTag) {
        super.readPacketData(pTag);
        this.fixedSpin = pTag.m_128457_(SPIN_KEY);
    }

    @Override
    @NotNull
    protected CompoundTag writePacketData(CompoundTag pTag) {
        pTag.m_128350_(SPIN_KEY, this.fixedSpin);
        return super.writePacketData(pTag);
    }
}

