/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.teacon.xkdeco.block.MimicWallBlock;
import org.teacon.xkdeco.init.MimicWallsLoader;
import org.teacon.xkdeco.init.XKDecoRecipes;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class MimicWallRecipe
extends ShapelessRecipe {
    private final Ingredient another;

    public MimicWallRecipe(ResourceLocation id, String group, CraftingBookCategory category, Ingredient another) {
        super(id, group, category, ItemStack.f_41583_, (NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), $ -> {
            $.add((Object)MimicWallRecipe.makeWallIngredient());
            $.add((Object)another);
        }));
        this.another = another;
    }

    public static Ingredient makeWallIngredient() {
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])MimicWallsLoader.MIMIC_WALLS.stream().map(MimicWallBlock::getWallDelegate).map(Block::m_5456_).toArray(Item[]::new)));
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(CraftingContainer input, RegistryAccess registries) {
        for (ItemStack itemStack : input.m_280657_()) {
            if (this.another.test(itemStack)) continue;
            for (MimicWallBlock mimicWall : MimicWallsLoader.MIMIC_WALLS) {
                if (!itemStack.m_150930_(mimicWall.getWallDelegate().m_5456_())) continue;
                return new ItemStack((ItemLike)mimicWall);
            }
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)XKDecoRecipes.MIMIC_WALL.get();
    }

    public static class Serializer
    implements RecipeSerializer<MimicWallRecipe> {
        public MimicWallRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String group = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Ingredient another = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"another"));
            return new MimicWallRecipe(pRecipeId, group, category, another);
        }

        public MimicWallRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
            Ingredient another = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            return new MimicWallRecipe(pRecipeId, group, category, another);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, MimicWallRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.m_6076_());
            pBuffer.m_130068_((Enum)pRecipe.m_245232_());
            pRecipe.another.m_43923_(pBuffer);
        }
    }
}

