/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.teacon.xkdeco.blockentity.ItemDisplayBlockEntity;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class ItemDisplayRenderer
implements BlockEntityRenderer<ItemDisplayBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.m_216327_();

    public ItemDisplayRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    public boolean shouldRender(ItemDisplayBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return pBlockEntity.isProjector() ? Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_()).m_82509_((Position)pCameraPos, (double)(Minecraft.m_91087_().f_91066_.m_193772_() * 16)) : super.m_142756_((BlockEntity)pBlockEntity, pCameraPos);
    }

    public void render(ItemDisplayBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemStack itemstack = pBlockEntity.getFirstItem();
        if (itemstack.m_41619_()) {
            return;
        }
        int speed = 1;
        BlockPos pos = pBlockEntity.m_58899_();
        float spin = pBlockEntity.getSpin();
        if (!pBlockEntity.hasFixedSpin()) {
            spin += pPartialTick;
        }
        spin *= 0.05f;
        this.random.m_188584_(itemstack.m_41619_() ? 187L : (long)(Item.m_41393_((Item)itemstack.m_41720_()) + itemstack.m_41773_()));
        pPoseStack.m_85836_();
        BakedModel bakedmodel = this.itemRenderer.m_174264_(itemstack, pBlockEntity.m_58904_(), null, speed);
        boolean gui3d = bakedmodel.m_7539_();
        int amount = this.getRenderAmount(itemstack);
        float modelScale = bakedmodel.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
        pPoseStack.m_85837_(0.5, (double)1.1f + 0.25 * (double)modelScale * (double)(pBlockEntity.isProjector() ? 24 : 1), 0.5);
        pPoseStack.m_252781_(Axis.f_252436_.m_252961_(spin));
        if (pBlockEntity.isProjector()) {
            pPoseStack.m_85841_(16.0f, 16.0f, 16.0f);
        }
        if (!gui3d) {
            pPoseStack.m_252880_(-0.0f * (float)(amount - 1) * 0.5f, -0.0f * (float)(amount - 1) * 0.5f, -0.09375f * (float)(amount - 1) * 0.5f);
        }
        for (int k = 0; k < amount; ++k) {
            pPoseStack.m_85836_();
            if (k > 0) {
                if (gui3d) {
                    pPoseStack.m_252880_((this.random.m_188501_() * 2.0f - 1.0f) * 0.15f, (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f, (this.random.m_188501_() * 2.0f - 1.0f) * 0.15f);
                } else {
                    pPoseStack.m_85837_((double)((this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f), (double)((this.random.m_188501_() * 2.0f - 1.0f) * 0.15f * 0.5f), 0.0);
                }
            }
            Level level = Objects.requireNonNull(pBlockEntity.m_58904_());
            BlockPos above = pos.m_7494_();
            int packedLight = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, above), (int)level.m_45517_(LightLayer.SKY, above));
            this.itemRenderer.m_115143_(itemstack, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, packedLight, OverlayTexture.f_118083_, bakedmodel);
            pPoseStack.m_85849_();
            if (gui3d) continue;
            pPoseStack.m_85837_(0.0, 0.0, 0.09375);
        }
        pPoseStack.m_85849_();
    }

    private int getRenderAmount(ItemStack pStack) {
        int i = 1;
        if (pStack.m_41613_() > 48) {
            i = 5;
        } else if (pStack.m_41613_() > 32) {
            i = 4;
        } else if (pStack.m_41613_() > 16) {
            i = 3;
        } else if (pStack.m_41613_() > 1) {
            i = 2;
        }
        return i;
    }
}

