/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;

public abstract class AbstractCarver {
    protected final CarverSettings settings;
    private final ImmutableSet<BlockState> DEBUG_BLOCKS = ImmutableSet.of((Object)Blocks.f_50074_.m_49966_(), (Object)Blocks.f_50705_.m_49966_(), (Object)Blocks.f_50652_.m_49966_(), (Object)Blocks.f_50330_.m_49966_(), (Object)Blocks.f_50268_.m_49966_(), (Object)Blocks.f_50076_.m_49966_(), (Object[])new BlockState[0]);

    public abstract int getSpawnWeight();

    public abstract int getBottomY();

    public abstract int getTopY();

    public abstract NoiseGen getNoiseGen();

    public AbstractCarver(CarverSettings settings) {
        this.settings = settings;
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, ChunkAccess chunkAccess, BlockPos blockPos, BlockState airBlockState, BlockState liquidBlockState, CarvingMask carvingMask, Aquifer aquifer) {
        carvingMask.m_187585_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        if (!chunkAccess.m_8055_(blockPos).m_204341_(config.misc.replaceable())) {
            return;
        }
        if (airBlockState.m_60795_() && blockPos.m_123342_() <= this.settings.getLiquidAltitude()) {
            if (liquidBlockState != null) {
                chunkAccess.m_6978_(blockPos, liquidBlockState, false);
            }
        } else {
            BlockState newBlockState = aquifer.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), 0.0);
            if (newBlockState == null) {
                return;
            }
            chunkAccess.m_6978_(blockPos, newBlockState, false);
            if (aquifer.m_142203_() && !newBlockState.m_60819_().m_76178_()) {
                chunkAccess.m_8113_(blockPos);
            }
        }
    }

    protected void carveBlock(BetterCavesWorldCarverConfig config, ChunkAccess chunkAccess, BlockPos blockPos, BlockState liquidBlockState, CarvingMask carvingMask, Aquifer aquifer) {
        this.carveBlock(config, chunkAccess, blockPos, Blocks.f_50016_.m_49966_(), liquidBlockState, carvingMask, aquifer);
    }

    protected void debugCarveBlock(ChunkAccess chunkIn, BlockPos blockPos, boolean digBlock) {
        if (this.DEBUG_BLOCKS.contains((Object)chunkIn.m_8055_(blockPos))) {
            return;
        }
        if (digBlock) {
            chunkIn.m_6978_(blockPos, this.settings.getDebugBlock(), false);
        } else {
            chunkIn.m_6978_(blockPos, Blocks.f_50016_.m_49966_(), false);
        }
    }
}

