/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverSettings;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;

public class CaveCarver
extends AbstractCarver {
    private final NoiseGen noiseGen;
    private final int surfaceCutoff;
    private final int bottomY;
    private final int topY;
    private final boolean enableYAdjust;
    private final float yAdjustF1;
    private final float yAdjustF2;

    public static List<AbstractCarver> createCarversFromConfig(ServerLevel serverLevel, BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CaveLayerSettings layerSettings) {
        ArrayList<AbstractCarver> carvers = new ArrayList<AbstractCarver>();
        layerSettings.carvers().forEach(carverSettings -> carvers.add(new Builder(serverLevel).fromConfig(config, (BetterCavesWorldCarverConfig.CaveLayerSettings.CaveSubCarverSettings)carverSettings).build()));
        return carvers;
    }

    private CaveCarver(Builder builder) {
        super(builder.getSettings());
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getYCompression(), this.settings.getXzCompression());
        this.surfaceCutoff = builder.getSurfaceCutoff();
        this.enableYAdjust = builder.isEnableYAdjust();
        this.yAdjustF1 = builder.getyAdjustF1();
        this.yAdjustF2 = builder.getyAdjustF2();
        if (builder.getBottomY() > builder.getTopY()) {
            BetterCavesCommon.LOGGER.warn("Warning: Min altitude for caves should not be greater than max altitude.");
            BetterCavesCommon.LOGGER.warn("Using default values...");
            throw new IllegalArgumentException("bettercaves: Cave Carver's bottomY cannot be greater than topY. Please check your config.");
        }
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
    }

    public void carveColumn(BetterCavesWorldCarverConfig config, ChunkAccess chunk, ColPos colPos, int topY, double[][] noiseColumn, BlockState liquidBlock, CarvingMask carvingMask, Aquifer aquifer) {
        int localX = colPos.getX() & 0xF;
        int localZ = colPos.getZ() & 0xF;
        int transitionBoundary = topY - this.surfaceCutoff;
        Map<Integer, Float> thresholds = this.generateThresholds(topY, this.bottomY, transitionBoundary);
        if (this.enableYAdjust) {
            this.preprocessCaveNoiseCol(noiseColumn, topY, this.bottomY, thresholds, this.settings.getNumGens());
        }
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos(localX, 1, localZ);
        BlockPos.MutableBlockPos realPos = new BlockPos.MutableBlockPos(colPos.getX(), 1, colPos.getZ());
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            double[] noiseBlock = noiseColumn[y - this.bottomY];
            boolean digBlock = true;
            for (double noise : noiseBlock) {
                if (!(noise < (double)thresholds.get(y).floatValue())) continue;
                digBlock = false;
                break;
            }
            localPos.m_122178_(localX, y, localZ);
            realPos.m_142448_(y);
            if (this.settings.isEnableDebugVisualizer()) {
                this.debugCarveBlock(chunk, (BlockPos)localPos, digBlock);
                continue;
            }
            if (!digBlock) continue;
            this.carveBlock(config, chunk, (BlockPos)realPos, liquidBlock, carvingMask, aquifer);
        }
    }

    private void preprocessCaveNoiseCol(double[][] noises, int topY, int bottomY, Map<Integer, Float> thresholds, int numGens) {
        for (int y = topY; y >= bottomY; --y) {
            int yIndex = y - bottomY;
            double[] noiseBlock = noises[yIndex];
            float threshold = thresholds.get(y).floatValue();
            boolean valid = true;
            for (double noise : noiseBlock) {
                if (!(noise < (double)threshold)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            float f1 = this.yAdjustF1;
            float f2 = this.yAdjustF2;
            if (y < topY) {
                double[] tupleAbove = noises[yIndex + 1];
                for (int i = 0; i < numGens; ++i) {
                    tupleAbove[i] = (double)(1.0f - f1) * tupleAbove[i] + (double)f1 * noiseBlock[i];
                }
            }
            if (y >= topY - 1) continue;
            double[] tupleTwoAbove = noises[yIndex + 2];
            for (int i = 0; i < numGens; ++i) {
                tupleTwoAbove[i] = (double)(1.0f - f2) * tupleTwoAbove[i] + (double)f2 * noiseBlock[i];
            }
        }
    }

    private Map<Integer, Float> generateThresholds(int topY, int bottomY, int transitionBoundary) {
        HashMap<Integer, Float> thresholds = new HashMap<Integer, Float>();
        for (int realY = bottomY; realY <= topY; ++realY) {
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (realY >= transitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - transitionBoundary) / (float)(topY - transitionBoundary));
            }
            thresholds.put(realY, Float.valueOf(noiseThreshold));
        }
        return thresholds;
    }

    @Override
    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getSpawnWeight() {
        return this.settings.getSpawnWeight();
    }

    @Override
    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }

    public static class Builder {
        private final CarverSettings settings;
        private int surfaceCutoff;
        private int bottomY;
        private int topY;
        private boolean enableYAdjust;
        private float yAdjustF1;
        private float yAdjustF2;

        public Builder(ServerLevel serverLevel) {
            this.settings = new CarverSettings(serverLevel);
        }

        public CaveCarver build() {
            return new CaveCarver(this);
        }

        private Builder fromConfig(BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CaveLayerSettings.CaveSubCarverSettings subCarverSettings) {
            this.settings.setEnableDebugVisualizer(config.debugSettings.enabled());
            this.settings.getNoiseSettings().setFractalType(FastNoise.FractalType.RigidMulti);
            this.settings.setDebugBlock(subCarverSettings.debugCarveState());
            this.settings.setFastNoise(subCarverSettings.advanced().isFastNoise());
            this.settings.setNoiseThreshold((float)subCarverSettings.advanced().noiseThreshold());
            this.settings.getNoiseSettings().setNoiseType(FastNoise.NoiseType.valueOf((String)subCarverSettings.advanced().noiseType()));
            this.settings.getNoiseSettings().setOctaves(subCarverSettings.advanced().fractalOctaves());
            this.settings.getNoiseSettings().setGain((float)subCarverSettings.advanced().fractalGain());
            this.settings.getNoiseSettings().setFrequency((float)subCarverSettings.advanced().fractalFrequency());
            this.settings.setNumGens(subCarverSettings.advanced().numGenerators());
            this.settings.setXzCompression((float)subCarverSettings.xzCompression());
            this.settings.setYCompression((float)subCarverSettings.yCompression());
            this.settings.setSpawnWeight(subCarverSettings.spawnWeight());
            this.surfaceCutoff = subCarverSettings.surfaceCutoffDistance();
            this.bottomY = subCarverSettings.bottomY();
            this.topY = subCarverSettings.topY();
            this.enableYAdjust = subCarverSettings.advanced().yAdjust();
            this.yAdjustF1 = (float)subCarverSettings.advanced().yAdjustF1();
            this.yAdjustF2 = (float)subCarverSettings.advanced().yAdjustF2();
            return this;
        }

        public CarverSettings getSettings() {
            return this.settings;
        }

        public int getSurfaceCutoff() {
            return this.surfaceCutoff;
        }

        public int getBottomY() {
            return this.bottomY;
        }

        public int getTopY() {
            return this.topY;
        }

        public boolean isEnableYAdjust() {
            return this.enableYAdjust;
        }

        public float getyAdjustF1() {
            return this.yAdjustF1;
        }

        public float getyAdjustF2() {
            return this.yAdjustF2;
        }
    }
}

