/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.AbstractCarver;
import com.yungnickyoung.minecraft.bettercaves.worldgen.carver.CarverSettings;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;

public class CavernCarver
extends AbstractCarver {
    private final NoiseGen noiseGen;
    private int bottomY;
    private int topY;
    private final boolean isFloored;

    public static List<AbstractCarver> createCarversFromConfig(ServerLevel serverLevel, BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CavernLayerSettings layerSettings) {
        ArrayList<AbstractCarver> carvers = new ArrayList<AbstractCarver>();
        layerSettings.carvers().forEach(carverSettings -> carvers.add(new Builder(serverLevel).fromConfig(config, (BetterCavesWorldCarverConfig.CavernLayerSettings.CavernSubCarverSettings)carverSettings).build()));
        return carvers;
    }

    public CavernCarver(Builder builder) {
        super(builder.getSettings());
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getYCompression(), this.settings.getXzCompression());
        if (this.bottomY > this.topY) {
            BetterCavesCommon.LOGGER.warn("Warning: Min altitude for caverns should not be greater than max altitude.");
            BetterCavesCommon.LOGGER.warn("Using default values...");
            throw new IllegalArgumentException("bettercaves: Cavern Carver's bottomY cannot be greater than topY. Please check your config.");
        }
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        this.isFloored = builder.isFloored();
    }

    public void carveColumn(BetterCavesWorldCarverConfig config, ChunkAccess chunk, ColPos colPos, int topY, float smoothAmp, double[][] noiseColumn, BlockState liquidBlock, CarvingMask carvingMask, Aquifer aquifer) {
        int localX = colPos.getX() & 0xF;
        int localZ = colPos.getZ() & 0xF;
        int topTransitionBoundary = (topY -= 2) - 6;
        int bottomTransitionBoundary = this.bottomY + 3;
        if (this.isFloored) {
            bottomTransitionBoundary = this.bottomY < this.settings.getLiquidAltitude() ? this.settings.getLiquidAltitude() + 8 : this.bottomY + 7;
        }
        BlockPos.MutableBlockPos localPos = new BlockPos.MutableBlockPos(localX, 1, localZ);
        BlockPos.MutableBlockPos realPos = new BlockPos.MutableBlockPos(colPos.getX(), 1, colPos.getZ());
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            double[] noiseBlock;
            boolean digBlock = false;
            float noise = 1.0f;
            for (double n : noiseBlock = noiseColumn[y - this.bottomY]) {
                noise *= (float)n;
            }
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (y >= topTransitionBoundary) {
                noiseThreshold *= (float)(y - topY) / (float)(topTransitionBoundary - topY);
            }
            if (y < bottomTransitionBoundary) {
                noiseThreshold *= (float)(y - this.bottomY) / (float)(bottomTransitionBoundary - this.bottomY);
            }
            if (smoothAmp < 1.0f) {
                noiseThreshold *= smoothAmp;
            }
            if (noise < noiseThreshold) {
                digBlock = true;
            }
            localPos.m_122178_(localX, y, localZ);
            realPos.m_142448_(y);
            if (this.settings.isEnableDebugVisualizer()) {
                this.debugCarveBlock(chunk, (BlockPos)localPos, digBlock);
                continue;
            }
            if (!digBlock) continue;
            this.carveBlock(config, chunk, (BlockPos)realPos, liquidBlock, carvingMask, aquifer);
        }
    }

    @Override
    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getSpawnWeight() {
        return this.settings.getSpawnWeight();
    }

    @Override
    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }

    public static class Builder {
        private final CarverSettings settings;
        private int bottomY;
        private int topY;
        private boolean isFloored;

        public Builder(ServerLevel serverLevel) {
            this.settings = new CarverSettings(serverLevel);
        }

        public CavernCarver build() {
            return new CavernCarver(this);
        }

        private Builder fromConfig(BetterCavesWorldCarverConfig config, BetterCavesWorldCarverConfig.CavernLayerSettings.CavernSubCarverSettings subCarverSettings) {
            this.settings.setEnableDebugVisualizer(config.debugSettings.enabled());
            this.settings.getNoiseSettings().setFractalType(FastNoise.FractalType.RigidMulti);
            this.settings.setDebugBlock(subCarverSettings.debugCarveState());
            this.settings.setFastNoise(subCarverSettings.advanced().isFastNoise());
            this.settings.setNoiseThreshold((float)subCarverSettings.advanced().noiseThreshold());
            this.settings.getNoiseSettings().setNoiseType(FastNoise.NoiseType.valueOf((String)subCarverSettings.advanced().noiseType()));
            this.settings.getNoiseSettings().setOctaves(subCarverSettings.advanced().fractalOctaves());
            this.settings.getNoiseSettings().setGain((float)subCarverSettings.advanced().fractalGain());
            this.settings.getNoiseSettings().setFrequency((float)subCarverSettings.advanced().fractalFrequency());
            this.settings.setNumGens(subCarverSettings.advanced().numGenerators());
            this.settings.setYCompression((float)subCarverSettings.yCompression());
            this.settings.setXzCompression((float)subCarverSettings.xzCompression());
            this.settings.setSpawnWeight(subCarverSettings.spawnWeight());
            this.bottomY = subCarverSettings.bottomY();
            this.topY = subCarverSettings.topY();
            this.isFloored = subCarverSettings.isFloored();
            return this;
        }

        public CarverSettings getSettings() {
            return this.settings;
        }

        public int getBottomY() {
            return this.bottomY;
        }

        public int getTopY() {
            return this.topY;
        }

        public boolean isFloored() {
            return this.isFloored;
        }
    }
}

