/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.layer.CaveLayer;
import com.yungnickyoung.minecraft.bettercaves.worldgen.layer.CavernLayer;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegionsController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Heightmap;

public class MasterController {
    private final ServerLevel serverLevel;
    private final BetterCavesWorldCarverConfig config;
    private final List<CaveLayer> caveLayers = new ArrayList<CaveLayer>();
    private final List<CavernLayer> cavernLayers = new ArrayList<CavernLayer>();
    private final Set<ChunkPos> carvedChunkCache = new HashSet<ChunkPos>();

    public MasterController(ServerLevel serverLevel, BetterCavesWorldCarverConfig config) {
        this.serverLevel = serverLevel;
        this.config = config;
        config.caveLayers.forEach(caveLayerSettings -> this.caveLayers.add(new CaveLayer(serverLevel, config, (BetterCavesWorldCarverConfig.CaveLayerSettings)caveLayerSettings)));
        config.cavernLayers.forEach(cavernLayerSettings -> this.cavernLayers.add(new CavernLayer(serverLevel, config, (BetterCavesWorldCarverConfig.CavernLayerSettings)cavernLayerSettings)));
        BetterCavesCommon.LOGGER.debug("MASTER CONTROLLER INITIALIZED");
    }

    public boolean carve(ChunkAccess chunkAccess, Function<BlockPos, Holder<Biome>> biomeProvider, CarvingMask carvingMask, Aquifer aquifer) {
        if (this.carvedChunkCache.contains(chunkAccess.m_7697_())) {
            return false;
        }
        int[][] surfaceAltitudes = this.getSurfaceAltitudes(chunkAccess);
        BlockState[][] liquidBlocks = LiquidRegionsController.getInstance().hasSettingsForLevel(this.serverLevel) ? LiquidRegionsController.getInstance().getLiquidRegionsForServerLevel(this.serverLevel).getOrCreateLiquidBlocksForChunk(chunkAccess.m_7697_()).liquidBlocks() : new BlockState[16][16];
        this.caveLayers.forEach(caveLayer -> caveLayer.carveChunk(chunkAccess, surfaceAltitudes, liquidBlocks, biomeProvider, carvingMask, aquifer));
        this.cavernLayers.forEach(cavernLayer -> cavernLayer.carveChunk(chunkAccess, surfaceAltitudes, liquidBlocks, biomeProvider, carvingMask, aquifer));
        this.carvedChunkCache.add(chunkAccess.m_7697_());
        return true;
    }

    private int[][] getSurfaceAltitudes(ChunkAccess chunkAccess) {
        int[][] surfaceAltitudes = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                surfaceAltitudes[x][z] = this.config.misc.overrideSurfaceDetection() ? 1 : Math.min(chunkAccess.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z), chunkAccess.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z));
            }
        }
        return surfaceAltitudes;
    }
}

