/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.dimension;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.adastra.client.dimension.ModSkyRenderer;
import earth.terrarium.adastra.client.dimension.PlanetRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ModDimensionSpecialEffects
extends DimensionSpecialEffects {
    private final PlanetRenderer renderer;
    private final ModSkyRenderer skyRenderer;

    public ModDimensionSpecialEffects(PlanetRenderer renderer) {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        this.renderer = renderer;
        this.skyRenderer = new ModSkyRenderer(renderer);
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        return this.renderer.customClouds();
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        this.skyRenderer.render(level, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        return this.renderer.customSky();
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return this.renderer.customWeather();
    }

    public Vec3 m_5927_(Vec3 fogColor, float brightness) {
        if (this.renderer.hasFog()) {
            return fogColor.m_82542_((double)brightness * 0.94 + 0.06, (double)brightness * 0.94 + 0.06, (double)brightness * 0.91 + 0.09);
        }
        return Vec3.f_82478_;
    }

    public boolean m_5781_(int x, int y) {
        return this.renderer.hasThickFog();
    }

    @Nullable
    public float[] m_7518_(float timeOfDay, float partialTicks) {
        if (this.renderer.sunriseAngle() != 0) {
            return null;
        }
        return ModDimensionSpecialEffects.getSunriseColor(timeOfDay, partialTicks, this.renderer.sunriseColor());
    }

    @Nullable
    public static float[] getSunriseColor(float timeOfDay, float partialTicks, int sunColor) {
        float timeCos = Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2)));
        if (timeCos >= -0.4f && timeCos <= 0.4f) {
            float time = timeCos / 0.4f * 0.5f + 0.5f;
            float alpha = 1.0f - (1.0f - Mth.m_14031_((float)(time * (float)Math.PI))) * 0.99f;
            alpha *= alpha;
            float[] rgba = new float[]{time * 0.3f + (float)FastColor.ARGB32.m_13665_((int)sunColor) / 255.0f * 0.7f, time * time * 0.7f + (float)FastColor.ARGB32.m_13667_((int)sunColor) / 255.0f * 0.5f, (float)FastColor.ARGB32.m_13669_((int)sunColor) / 255.0f * 0.6f, alpha};
            return rgba;
        }
        return null;
    }

    public PlanetRenderer renderer() {
        return this.renderer;
    }
}

