/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.menus.base;

import earth.terrarium.adastra.common.menus.slots.InventorySlot;
import earth.terrarium.adastra.common.utils.WorldUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContainerMenu<T extends BlockEntity>
extends AbstractContainerMenu {
    private static final int START_INDEX = 0;
    protected final T entity;
    protected final Inventory inventory;
    protected final Player player;
    protected final Level level;

    public BaseContainerMenu(@Nullable MenuType<?> type, int id, Inventory inventory, T entity) {
        super(type, id);
        this.entity = entity;
        this.inventory = inventory;
        this.player = inventory.f_35978_;
        this.level = this.player.m_9236_();
        if (entity == null) {
            return;
        }
        this.addMenuSlots();
        this.addPlayerInvSlots();
    }

    public T getEntity() {
        return this.entity;
    }

    protected abstract int getContainerInputEnd();

    protected abstract int getInventoryStart();

    protected int startIndex() {
        return 0;
    }

    public abstract int getPlayerInvXOffset();

    public abstract int getPlayerInvYOffset();

    protected abstract void addMenuSlots();

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemStack = slotItem.m_41777_();
            if (index < this.getInventoryStart() ? !this.m_38903_(slotItem, this.getInventoryStart(), this.f_38839_.size(), true) : !this.m_38903_(slotItem, this.startIndex(), this.getContainerInputEnd(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    protected void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new InventorySlot((Container)this.inventory, j + i * 9 + 9, this.getPlayerInvXOffset() + j * 18, this.getPlayerInvYOffset() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new InventorySlot((Container)this.inventory, i, this.getPlayerInvXOffset() + i * 18, this.getPlayerInvYOffset() + 58));
        }
    }

    public void m_150399_(int slotIndex, int button, @NotNull ClickType actionType, @NotNull Player player) {
        super.m_150399_(slotIndex, button, actionType, player);
        this.m_182423_();
    }

    public static <T extends BlockEntity> T getBlockEntityFromBuf(Level level, FriendlyByteBuf buf, Class<T> type) {
        if (buf == null) {
            return null;
        }
        if (!level.f_46443_) {
            return null;
        }
        return WorldUtils.getTileEntity(type, level, buf.m_130135_());
    }
}

