/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.mojang.authlib.GameProfile;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.compat.argonauts.ArgonautsIntegration;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.SpaceStationHandler;
import earth.terrarium.adastra.common.handlers.base.SpaceStation;
import earth.terrarium.adastra.common.network.CodecPacketType;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record ServerboundLandOnSpaceStationPacket(ResourceKey<Level> dimension, ChunkPos spaceStationPos) implements Packet<ServerboundLandOnSpaceStationPacket>
{
    public static final ServerboundPacketType<ServerboundLandOnSpaceStationPacket> TYPE = new Type();

    public PacketType<ServerboundLandOnSpaceStationPacket> type() {
        return TYPE;
    }

    private static boolean isAllowed(ServerPlayer player, ServerLevel level, ChunkPos targetPos) {
        HashSet<SpaceStation> stations = new HashSet<SpaceStation>(SpaceStationHandler.getOwnedSpaceStations(player, level));
        if (!ArgonautsIntegration.argonautsLoaded()) {
            return stations.stream().anyMatch(station -> station.position().equals((Object)targetPos));
        }
        for (GameProfile member : ArgonautsIntegration.getClientPartyMembers(player.m_20148_())) {
            stations.addAll(SpaceStationHandler.getOwnedSpaceStations(member.getId(), level));
        }
        for (GameProfile member : ArgonautsIntegration.getClientGuildMembers(player.m_20148_())) {
            stations.addAll(SpaceStationHandler.getOwnedSpaceStations(member.getId(), level));
        }
        return stations.stream().anyMatch(station -> station.position().equals((Object)targetPos));
    }

    private static class Type
    extends CodecPacketType<ServerboundLandOnSpaceStationPacket>
    implements ServerboundPacketType<ServerboundLandOnSpaceStationPacket> {
        public Type() {
            super(ServerboundLandOnSpaceStationPacket.class, new ResourceLocation("ad_astra", "land_on_space_station"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundLandOnSpaceStationPacket::dimension), (ObjectEntryByteCodec)ExtraByteCodecs.CHUNK_POS.fieldOf(ServerboundLandOnSpaceStationPacket::spaceStationPos), ServerboundLandOnSpaceStationPacket::new));
        }

        public Consumer<Player> handle(ServerboundLandOnSpaceStationPacket packet) {
            return player -> {
                Level patt2688$temp = player.m_9236_();
                if (!(patt2688$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)patt2688$temp;
                if (!(player instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                ServerLevel targetLevel = serverLevel.m_7654_().m_129880_(planet.dimension());
                if (targetLevel == null) {
                    return;
                }
                if (!PlanetApi.API.isSpace((Level)targetLevel)) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                ChunkPos targetPos = packet.spaceStationPos();
                if (!ServerboundLandOnSpaceStationPacket.isAllowed(serverPlayer, targetLevel, targetPos)) {
                    return;
                }
                BlockPos middleBlockPosition = targetPos.m_151394_(AdAstraConfig.atmosphereLeave);
                ModUtils.land(serverPlayer, targetLevel, new Vec3((double)((float)middleBlockPosition.m_123341_() - 0.5f), (double)middleBlockPosition.m_123342_(), (double)((float)middleBlockPosition.m_123343_() - 0.5f)));
            };
        }
    }
}

