/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.DistributionMode;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;

public class TooltipUtils {
    public static String getFormattedAmount(long number) {
        if (Screen.m_96638_()) {
            return DecimalFormat.getNumberInstance().format(number);
        }
        NumberFormat compactFormat = NumberFormat.getCompactNumberInstance(Locale.ROOT, NumberFormat.Style.SHORT);
        compactFormat.setMaximumFractionDigits(2);
        return compactFormat.format(number);
    }

    public static Component getEnergyComponent(long energy, long capacity) {
        return Component.m_237110_((String)"tooltip.ad_astra.energy", (Object[])new Object[]{TooltipUtils.getFormattedAmount(energy), TooltipUtils.getFormattedAmount(capacity)}).m_130940_(ChatFormatting.GOLD);
    }

    public static Component getEnergyDifferenceComponent(long energy) {
        return Component.m_237110_((String)"tooltip.ad_astra.energy_%s".formatted(energy < 0L ? "out" : "in"), (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(energy))}).m_130940_(ChatFormatting.GOLD);
    }

    public static Component getMaxEnergyInComponent(long maxIn) {
        return Component.m_237110_((String)"tooltip.ad_astra.max_energy_in", (Object[])new Object[]{TooltipUtils.getFormattedAmount(maxIn)}).m_130940_(ChatFormatting.GREEN);
    }

    public static Component getMaxEnergyOutComponent(long maxOut) {
        return Component.m_237110_((String)"tooltip.ad_astra.max_energy_out", (Object[])new Object[]{TooltipUtils.getFormattedAmount(maxOut)}).m_130940_(ChatFormatting.GREEN);
    }

    public static Component getEnergyUsePerTickComponent(long usePerTick) {
        return Component.m_237110_((String)"tooltip.ad_astra.energy_use_per_tick", (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(usePerTick))}).m_130940_(ChatFormatting.AQUA);
    }

    public static Component getEnergyGenerationPerTickComponent(long generationPerTick) {
        return Component.m_237110_((String)"tooltip.ad_astra.energy_generation_per_tick", (Object[])new Object[]{TooltipUtils.getFormattedAmount(Math.abs(generationPerTick))}).m_130940_(ChatFormatting.AQUA);
    }

    public static Component getActiveInactiveComponent(boolean active) {
        return active ? ConstantComponents.ACTIVE.m_6881_().m_130940_(ChatFormatting.AQUA) : ConstantComponents.INACTIVE.m_6881_().m_130940_(ChatFormatting.AQUA);
    }

    public static Component getDistributionModeComponent(DistributionMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case DistributionMode.SEQUENTIAL -> ConstantComponents.SEQUENTIAL.m_6881_().m_130940_(ChatFormatting.AQUA);
            case DistributionMode.ROUND_ROBIN -> ConstantComponents.ROUND_ROBIN.m_6881_().m_130940_(ChatFormatting.AQUA);
        };
    }

    public static Component getFluidComponent(FluidHolder fluid, long capacity, Fluid fallback) {
        if (fluid.isEmpty()) {
            return Component.m_237110_((String)"tooltip.ad_astra.fluid", (Object[])new Object[]{TooltipUtils.getFormattedAmount(0L), TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)capacity)), ClientFluidHooks.getDisplayName((FluidHolder)FluidHolder.ofMillibuckets((Fluid)fallback, (long)capacity))}).m_130940_(ChatFormatting.GOLD);
        }
        return TooltipUtils.getFluidComponent(fluid, capacity);
    }

    public static Component getFluidComponent(FluidHolder fluid, long capacity) {
        return Component.m_237110_((String)"tooltip.ad_astra.fluid", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)fluid.getFluidAmount())), TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)capacity)), ClientFluidHooks.getDisplayName((FluidHolder)fluid)}).m_130940_(ChatFormatting.GOLD);
    }

    public static Component getFluidDifferenceComponent(long fluid) {
        return Component.m_237110_((String)"tooltip.ad_astra.fluid_%s".formatted(fluid < 0L ? "out" : "in"), (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(fluid)))}).m_130940_(ChatFormatting.GOLD);
    }

    public static Component getMaxFluidInComponent(long maxIn) {
        return Component.m_237110_((String)"tooltip.ad_astra.max_fluid_in", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)maxIn))}).m_130940_(ChatFormatting.GREEN);
    }

    public static Component getMaxFluidOutComponent(long maxOut) {
        return Component.m_237110_((String)"tooltip.ad_astra.max_fluid_out", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)maxOut))}).m_130940_(ChatFormatting.GREEN);
    }

    public static Component getFluidUsePerIterationComponent(long usePerTick) {
        return Component.m_237110_((String)"tooltip.ad_astra.fluid_use_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(usePerTick)))}).m_130940_(ChatFormatting.AQUA);
    }

    public static Component getFluidGenerationPerIterationComponent(long gainPerTick) {
        return Component.m_237110_((String)"tooltip.ad_astra.fluid_generation_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(FluidConstants.toMillibuckets((long)Math.abs(gainPerTick)))}).m_130940_(ChatFormatting.AQUA);
    }

    public static Component getTicksPerIterationComponent(int time) {
        return Component.m_237110_((String)"tooltip.ad_astra.ticks_per_iteration", (Object[])new Object[]{TooltipUtils.getFormattedAmount(time)}).m_130940_(ChatFormatting.AQUA);
    }

    public static Component getDirectionComponent(Direction direction) {
        return Component.m_237115_((String)"direction.ad_astra.%s".formatted(direction.m_122433_()));
    }

    public static Component getRelativeDirectionComponent(Direction direction) {
        return Component.m_237115_((String)"direction.ad_astra.relative.%s".formatted(direction.m_122433_()));
    }

    public static void addDescriptionComponent(List<Component> tooltipComponents, Component description) {
        if (!Screen.m_96638_()) {
            tooltipComponents.add(ConstantComponents.SHIFT_DESCRIPTION);
            return;
        }
        for (FormattedCharSequence text : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)description, 200)) {
            StringBuilder builder = new StringBuilder();
            text.m_13731_((i, style, codePoint) -> {
                builder.appendCodePoint(codePoint);
                return true;
            });
            tooltipComponents.add((Component)Component.m_237113_((String)builder.toString()).m_130948_(description.m_7383_()));
        }
    }

    public static Component getProgressComponent(int progress, int maxProgress) {
        return Component.m_237110_((String)"tooltip.ad_astra.progress", (Object[])new Object[]{progress, maxProgress}).m_130940_(ChatFormatting.GOLD);
    }

    public static Component getEtaComponent(int progress, int maxProgress, boolean reverse) {
        int eta = (maxProgress - progress) / 20;
        if (reverse) {
            eta = progress / 20;
        }
        return Component.m_237110_((String)"tooltip.ad_astra.eta", (Object[])new Object[]{eta}).m_130940_(ChatFormatting.GOLD);
    }
}

