/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.addonslib.api.data.BlockId;
import fr.addonslib.api.data.McwBlockIdBase;
import fr.addonslib.api.data.McwBlocksIdBase;
import fr.addonslib.api.data.ModType;
import fr.addonslib.api.recipes.CraftingIngredient;
import fr.addonslib.api.recipes.RecipesBase;
import fr.addonslib.api.recipes.material.McwStoneMat;
import fr.addonslib.api.recipes.material.McwWoodMat;
import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public abstract class McwRecipes
extends RecipeProvider {
    public McwRecipes(PackOutput p_248933_) {
        super(p_248933_);
    }

    private void makeRecipesWood(McwBlockIdBase mcwBlockIdBase, Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < woodMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwWoodMat<Block> woodMat = woodMats.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (ItemLike)woodMat.getLog(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (ItemLike)woodMat.getLog(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (ItemLike)woodMat.getLog(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), (ItemLike)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private void makeRecipesStone(McwBlockIdBase mcwBlockIdBase, Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < stoneMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwStoneMat<Block> stoneMat = stoneMats.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (ItemLike)stoneMat.getStoneBase(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (ItemLike)stoneMat.getStoneBase(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (ItemLike)stoneMat.getStoneBase(), recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeStonecutter": {
                                this.recipeStonecutter(output, (ItemLike)result, (ItemLike)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private Item replaceTypeWood(String MODID, String mat, McwWoodMat<Block> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stripped_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_table");
            }
            case "table": {
                return Finder.findItem(MODID, mat + "_table");
            }
            case "log_bridge": {
                return Finder.findItem(MODID, mat + "_log_bridge_middle");
            }
            case "log_bridge_stair": {
                return Finder.findItem(MODID, mat + "_log_bridge_stair");
            }
            case "wardrobe": {
                return Finder.findItem(MODID, mat + "_wardrobe");
            }
            case "stripped_wardrobe": {
                return Finder.findItem(MODID, "stripped_" + mat + "_wardrobe");
            }
            case "coffee_table": {
                return Finder.findItem(MODID, mat + "_coffee_table");
            }
            case "stripped_coffee_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_coffee_table");
            }
            case "stable_door": {
                return Finder.findItem(MODID, mat + "_stable_door");
            }
            case "rope_bridge": {
                return Finder.findItem(MODID, "rope_" + mat + "_bridge");
            }
            case "balcony": {
                return Finder.findItem(MODID, mat + "_balcony");
            }
            case "drawer": {
                return Finder.findItem(MODID, mat + "_drawer");
            }
            case "stripped_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_drawer");
            }
            case "double_drawer": {
                return Finder.findItem(MODID, mat + "_double_drawer");
            }
            case "stripped_double_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_double_drawer");
            }
            case "stripped_end_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_end_table");
            }
            case "end_table": {
                return Finder.findItem(MODID, mat + "_end_table");
            }
            case "rope_bridge_stair": {
                return Finder.findItem(MODID, mat + "_rope_bridge_stair");
            }
            case "glass_trapdoor": {
                return Finder.findItem(MODID, mat + "_glass_trapdoor");
            }
            case "mcwfurnitures:cabinet_door": {
                return Finder.findItem("mcwfurnitures:cabinet_door");
            }
            case "mcwfurnitures:cabinet_drawer": {
                return Finder.findItem("mcwfurnitures:cabinet_drawer");
            }
            case "mcwwindows:window_base": {
                return Finder.findItem("mcwwindows:window_base");
            }
            case "mcwwindows:window_half_bar_base": {
                return Finder.findItem("mcwwindows:window_half_bar_base");
            }
            case "mcwwindows:window_centre_bar_base": {
                return Finder.findItem("mcwwindows:window_centre_bar_base");
            }
            case "minecraft:stick": {
                return Items.f_42398_;
            }
            case "minecraft:iron_bars": {
                return Items.f_42025_;
            }
            case "minecraft:cauldron": {
                return Items.f_42544_;
            }
            case "minecraft:water_bucket": {
                return Items.f_42447_;
            }
            case "minecraft:barrel": {
                return Items.f_42768_;
            }
            case "minecraft:paper": {
                return Items.f_42516_;
            }
            case "minecraft:glass_pane": {
                return Items.f_42027_;
            }
            case "minecraft:glass": {
                return Items.f_41904_;
            }
            case "minecraft:string": {
                return Items.f_42401_;
            }
            case "minecraft:book": {
                return Items.f_42517_;
            }
            case "log": {
                return woodMat.getLog().m_5456_();
            }
            case "planks": {
                return woodMat.getPlanks().m_5456_();
            }
            case "strippedLog": {
                return woodMat.getStrippedLog().m_5456_();
            }
            case "slab": {
                return woodMat.getSlab().m_5456_();
            }
            case "fence": {
                return woodMat.getFence().m_5456_();
            }
            case "trapdoor": {
                return woodMat.getTrapdoor().m_5456_();
            }
        }
        return Finder.findItem(type.getName());
    }

    private Item replaceTypeStone(String MODID, String mat, McwStoneMat<Block> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stone_bridge": {
                return Finder.findItem(MODID, mat + "_bridge");
            }
            case "stone_bridge_stair": {
                return Finder.findItem(MODID, mat + "_bridge_stair");
            }
            case "minecraft:dirt": {
                return Items.f_42329_;
            }
            case "minecraft:iron_bars": {
                return Items.f_42025_;
            }
            case "minecraft:glass_pane": {
                return Items.f_42027_;
            }
            case "minecraft:glass": {
                return Items.f_41904_;
            }
            case "stoneBase": {
                return woodMat.getStoneBase().m_5456_();
            }
            case "stoneSlab": {
                return woodMat.getSlab().m_5456_();
            }
            case "stoneWall": {
                return woodMat.getWall().m_5456_();
            }
            case "smoothStone": {
                return woodMat.getSmoothStone().m_5456_();
            }
        }
        return Items.f_41852_;
    }

    protected void registerMcwWood(Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidWood(mod);
            this.makeRecipesWood(mcwBlockIdBase, output, modid, originalMod, MAT, woodMats);
        }
    }

    protected void registerMcwStone(Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidStone(mod);
            this.makeRecipesStone(mcwBlockIdBase, output, modid, originalMod, MAT, stoneMats);
        }
    }

    protected void registerMcwHedge(Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<Block> blockLeave) {
        McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.FENCES_LEAVE_BLOCKS;
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < blockLeave.size(); ++i) {
                    String mat = MAT.get(i);
                    Block leave = blockLeave.get(i);
                    Block result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (ItemLike)leave, recipeBase.getPattern(), (ItemLike)result, recipeBase.getCount(), (ItemLike)leave, recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    public void registerAllMcwWood(Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<Block>> woodMats) {
        this.registerMcwWood(output, modid, originalMod, MAT, woodMats, Registration.getAllModTypeWood());
    }

    public void registerAllMcwStone(Consumer<FinishedRecipe> output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<Block>> stoneMats) {
        this.registerMcwStone(output, modid, originalMod, MAT, stoneMats, Registration.getAllModTypeStone());
    }

    protected void recipeShapelessWith1Item(Consumer<FinishedRecipe> output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String originalMod, String mcwMod) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126211_(firstItem, required).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
    }

    protected void recipeShapelessWith1ItemRecycle(Consumer<FinishedRecipe> output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String originalMod, String mcwMod) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126211_(firstItem, required).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, ResourceLocation.fromNamespaceAndPath((String)Finder.getModidOfItem(result.m_5456_()), (String)(Finder.getIdOfItem(result.m_5456_()) + "_recycle")));
    }

    protected void recipeShapedWith1Item(Consumer<FinishedRecipe> output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group, String originalMod, String mcwMod) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126130_(pattern[2]).m_126127_(Character.valueOf('A'), firstItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126127_(Character.valueOf('A'), firstItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126127_(Character.valueOf('A'), firstItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        }
    }

    protected void recipeShapedWith2Items(Consumer<FinishedRecipe> output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, String group, String originalMod, String mcwMod) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126130_(pattern[2]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        }
    }

    protected void recipeShapedWith3Items(Consumer<FinishedRecipe> output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, String group, String originalMod, String mcwMod) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126130_(pattern[2]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        }
    }

    protected void recipeShapedWith4Items(Consumer<FinishedRecipe> output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, ItemLike fourItem, String group, String originalMod, String mcwMod) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126130_(pattern[2]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126127_(Character.valueOf('D'), fourItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126130_(pattern[1]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126127_(Character.valueOf('D'), fourItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        } else {
            ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).m_126130_(pattern[0]).m_126127_(Character.valueOf('A'), firstItem).m_126127_(Character.valueOf('B'), secondItem).m_126127_(Character.valueOf('C'), thirdItem).m_126127_(Character.valueOf('D'), fourItem).m_126145_(group).m_126132_(McwRecipes.m_176602_((ItemLike)planks), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)planks))).m_176498_(arg_0)).generateAdvancement().build(output, Finder.getRLOfItem(result.m_5456_()));
        }
    }

    protected void recipeStonecutter(Consumer<FinishedRecipe> output, ItemLike result, ItemLike firstItem, String originalMod, String mcwMod) {
        String recipeId = Finder.getModidOfItem(result.m_5456_()) + ":" + Finder.getIdOfItem(result.m_5456_()) + "_stonecutter";
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(mcwMod)).addCondition((ICondition)new ModLoadedCondition(originalMod)).addRecipe(c -> SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{firstItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).m_126132_(McwRecipes.m_176602_((ItemLike)firstItem), (CriterionTriggerInstance)McwRecipes.m_125977_((ItemLike)firstItem)).m_176500_(c, recipeId)).generateAdvancement().build(output, ResourceLocation.parse((String)recipeId));
    }
}

