/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticframes.datagen;

import com.supermartijn642.fusion.api.provider.FusionTextureMetadataProvider;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import net.alminoris.aestheticframes.util.helper.BlockSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class ModFusionTextureMetadataProvider
extends FusionTextureMetadataProvider {
    public ModFusionTextureMetadataProvider(PackOutput output) {
        super("aestheticframes", output);
    }

    protected void generate() {
        for (String name : BlockSetsHelper.getWoods()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                this.registerPiecedConnectingTextureType(frameName + "frame_" + name);
                this.registerFullConnectingTextureType(frameName + "scaled_frame_" + name);
            }
        }
        for (String name : BlockSetsHelper.getStones()) {
            for (String frameName : BlockSetsHelper.FRAME_TYPES) {
                this.registerPiecedConnectingTextureType(frameName + "frame_" + name);
                this.registerFullConnectingTextureType(frameName + "scaled_frame_" + name);
            }
        }
    }

    private void registerPiecedConnectingTextureType(String name) {
        ConnectingTextureData textureData = (ConnectingTextureData)ConnectingTextureData.builder().layout(ConnectingTextureLayout.PIECED).build();
        this.addTextureMetadata(ResourceLocation.fromNamespaceAndPath((String)"aestheticframes", (String)("block/" + name)), DefaultTextureTypes.CONNECTING, textureData);
    }

    private void registerFullConnectingTextureType(String name) {
        ConnectingTextureData textureData = (ConnectingTextureData)ConnectingTextureData.builder().layout(ConnectingTextureLayout.FULL).build();
        this.addTextureMetadata(ResourceLocation.fromNamespaceAndPath((String)"aestheticframes", (String)("block/" + name)), DefaultTextureTypes.CONNECTING, textureData);
    }
}

