/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.entity.vehicle;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IBoatNoAnchor;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveBlockOnlyCompartments;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveCleats;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IPaintable;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.alekiships.network.AlekiShipsEntityDataSerializers;
import com.alekiponi.alekiships.util.BoatMaterial;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RowboatEntity
extends AbstractAlekiBoatEntity
implements IPaintable,
IHaveBlockOnlyCompartments,
IHaveCleats,
IBoatNoAnchor {
    private static final EntityDataAccessor<Byte> DATA_ID_OARS = SynchedEntityData.m_135353_(RowboatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<DyeColor>> DATA_ID_PAINT_COLOR = SynchedEntityData.m_135353_(RowboatEntity.class, (EntityDataSerializer)((EntityDataSerializer)AlekiShipsEntityDataSerializers.OPTIONAL_DYE_COLOR.get()));
    public final int PASSENGER_NUMBER = 6;
    public final int[] CLEATS = new int[]{5};
    public final int[][] COMPARTMENT_ROTATIONS = new int[][]{{0, 180}};
    public final int[] CAN_ADD_ONLY_BLOCKS = new int[]{2, 1};
    public final int[] COMPARTMENTS = new int[]{0, 1, 2, 3, 4};
    protected final float PASSENGER_SIZE_LIMIT = 1.4f;
    protected final float DAMAGE_THRESHOLD = 128.0f;
    protected final float DAMAGE_RECOVERY = 5.333f;

    public RowboatEntity(EntityType<? extends RowboatEntity> entityType, Level level, BoatMaterial boatMaterial) {
        super(entityType, level, boatMaterial);
    }

    @Override
    public float getPassengerSizeLimit() {
        return 1.4f;
    }

    @Override
    protected void tickWindInput() {
        if (this.windShouldAffect()) {
            super.tickWindInput();
        }
    }

    @Override
    public int getMaxPassengers() {
        return this.PASSENGER_NUMBER;
    }

    @Override
    public int[] getCleatIndices() {
        return this.CLEATS;
    }

    @Override
    public int[] getColliderIndices() {
        return new int[0];
    }

    @Override
    public int[] getCompartmentIndices() {
        return this.COMPARTMENTS;
    }

    @Override
    public int[] getCanAddOnlyBlocksIndices() {
        return this.CAN_ADD_ONLY_BLOCKS;
    }

    @Override
    public float getCleatMovementMultiplier() {
        return 10.0f;
    }

    @Override
    public AbstractCompartmentEntity.RidingPose[] getRidingPoses() {
        if (this.ridingPoses.length == 0) {
            AbstractCompartmentEntity.RidingPose[] poses = new AbstractCompartmentEntity.RidingPose[this.getMaxPassengers()];
            for (int i = 1; i < this.getMaxPassengers(); ++i) {
                poses[i] = AbstractCompartmentEntity.RidingPose.COMPACT;
            }
            poses[0] = AbstractCompartmentEntity.RidingPose.STANDARD;
            this.ridingPoses = poses;
        }
        return this.ridingPoses;
    }

    @Override
    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        switch (index) {
            case 0: {
                localX = 1.1f;
                localZ = 0.0f;
                localY += 0.2f;
                break;
            }
            case 1: {
                localX = -0.95f;
                localZ = 0.375f;
                localY += 0.1f;
                break;
            }
            case 2: {
                localX = -0.95f;
                localZ = -0.375f;
                localY += 0.1f;
                break;
            }
            case 3: {
                localX = -0.1f;
                localZ = 0.375f;
                localY += 0.1f;
                break;
            }
            case 4: {
                localX = -0.1f;
                localZ = -0.375f;
                localY += 0.1f;
                break;
            }
            case 5: {
                localX = 1.72f;
                localZ = 0.0f;
                localY += 0.937f;
            }
        }
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    @Override
    public float getDamageThreshold() {
        return 128.0f;
    }

    @Override
    public float getDamageRecovery() {
        return 5.333f;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (!this.m_9236_().f_46443_ && removalReason.m_146965_()) {
            this.m_5496_(SoundEvents.f_12630_, 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        super.m_142687_(removalReason);
    }

    @Override
    protected float getPaddleMultiplier() {
        float paddleMultiplier = 1.0f;
        if (this.getOars() != Oars.ZERO) {
            paddleMultiplier = 1.6f;
        }
        return paddleMultiplier;
    }

    @Override
    protected float getTurnSpeed() {
        return 0.7f;
    }

    @Override
    protected float getMomentumSubtractor() {
        return 0.005f;
    }

    @Override
    public int getCompartmentRotation(int i) {
        return this.COMPARTMENT_ROTATIONS[i][0];
    }

    @Override
    public int[][] getCompartmentRotationsArray() {
        return this.COMPARTMENT_ROTATIONS;
    }

    @Override
    public Item getDropItem() {
        return this.boatMaterial.getDeckItem();
    }

    @Override
    protected void dropCustomDestructionLoot(DamageSource damageSource) {
        super.dropCustomDestructionLoot(damageSource);
        switch (this.getOars()) {
            case ZERO: {
                break;
            }
            case TWO: {
                this.m_19998_((ItemLike)AlekiShipsItems.OAR.get());
            }
            case ONE: {
                this.m_19998_((ItemLike)AlekiShipsItems.OAR.get());
            }
        }
    }

    @Override
    @Nullable
    public Entity getPilotVehiclePartAsEntity() {
        if (this.m_20160_() && this.m_20197_().size() == this.getMaxPassengers()) {
            return (Entity)this.m_20197_().get(0);
        }
        return null;
    }

    public Oars getOars() {
        return Oars.byId(((Byte)this.f_19804_.m_135370_(DATA_ID_OARS)).byteValue());
    }

    public void setOars(Oars oars) {
        this.f_19804_.m_135381_(DATA_ID_OARS, (Object)((byte)oars.ordinal()));
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        InteractionResult result = this.interactPaint(player, hand);
        if (result != null) {
            return result;
        }
        if (heldItem.m_150930_((Item)AlekiShipsItems.OAR.get()) && this.getOars() != Oars.TWO) {
            this.addOar();
            heldItem.m_41620_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void addOar() {
        switch (this.getOars()) {
            case ZERO: {
                this.setOars(Oars.ONE);
                break;
            }
            case ONE: {
                this.setOars(Oars.TWO);
                break;
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_OARS, (Object)((byte)Oars.ZERO.getId()));
        this.f_19804_.m_135372_(DATA_ID_PAINT_COLOR, Optional.empty());
    }

    @Override
    protected double windDriftMultiplier() {
        return 0.5;
    }

    @Override
    public Optional<DyeColor> getPaintColor() {
        return (Optional)this.f_19804_.m_135370_(DATA_ID_PAINT_COLOR);
    }

    @Override
    public void setPaintColor(DyeColor paintColor) {
        this.f_19804_.m_135381_(DATA_ID_PAINT_COLOR, Optional.of(paintColor));
    }

    @Override
    public void clearPaint() {
        this.f_19804_.m_135381_(DATA_ID_PAINT_COLOR, Optional.empty());
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setOars(Oars.byId(compoundTag.m_128445_("oars")));
        if (compoundTag.m_128425_("paint", 1)) {
            this.setPaintColor(DyeColor.m_41053_((int)compoundTag.m_128445_("paint")));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128344_("oars", (byte)this.getOars().getId());
        this.getPaintColor().ifPresent(dyeColor -> compoundTag.m_128344_("paint", (byte)dyeColor.m_41060_()));
    }

    public float getStepHeight() {
        return 0.0f;
    }

    public static enum Oars {
        ZERO(0),
        ONE(1),
        TWO(2);

        private static final IntFunction<Oars> BY_ID;
        private final int id;

        private Oars(int id) {
            this.id = id;
        }

        public static Oars byId(int id) {
            return BY_ID.apply(id);
        }

        public int getId() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Oars::getId, (Object[])Oars.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

