/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.network;

import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCompartmentInputPacket {
    private final boolean inputLeft;
    private final boolean inputRight;
    private final boolean inputUp;
    private final boolean inputDown;
    private final int entityID;

    public ServerboundCompartmentInputPacket(boolean inputLeft, boolean inputRight, boolean inputUp, boolean inputDown, int id) {
        this.inputLeft = inputLeft;
        this.inputRight = inputRight;
        this.inputUp = inputUp;
        this.inputDown = inputDown;
        this.entityID = id;
    }

    public ServerboundCompartmentInputPacket(FriendlyByteBuf buffer) {
        this.inputLeft = buffer.readBoolean();
        this.inputRight = buffer.readBoolean();
        this.inputUp = buffer.readBoolean();
        this.inputDown = buffer.readBoolean();
        this.entityID = buffer.readInt();
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.inputLeft);
        buffer.writeBoolean(this.inputRight);
        buffer.writeBoolean(this.inputUp);
        buffer.writeBoolean(this.inputDown);
        buffer.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(this.entityID);
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (entity instanceof EmptyCompartmentEntity) {
                EmptyCompartmentEntity compartment = (EmptyCompartmentEntity)entity;
                assert (player != null);
                if (player.m_20270_((Entity)compartment) < 2.0f) {
                    compartment.setInput(this.inputLeft, this.inputRight, this.inputUp, this.inputDown);
                }
            }
        });
    }
}

