/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.wind;

import com.alekiponi.alekiships.wind.Wind;
import com.alekiponi.alekiships.wind.WindModel;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.world.level.Level;

public class OverworldWindModel
implements WindModel {
    private Level level;

    public OverworldWindModel(Level level) {
        this.level = level;
    }

    @Override
    public Wind getWind(BlockPos blockPos) {
        long time = this.level.m_46467_();
        long days = time / 24000L;
        Random random = this.seededRandom(days, 129341623413L);
        boolean isDay = this.level.m_46468_() % 24000L < 12000L;
        int windScale = 5000;
        boolean oddBand = blockPos.m_123343_() < 0 ? blockPos.m_123343_() % (windScale * 2) < windScale : blockPos.m_123343_() % (windScale * 2) > windScale;
        float intensity = random.nextFloat() * 0.3f + 0.3f + 0.4f * this.level.m_46722_(0.0f);
        float angle = isDay && oddBand ? 0.7853982f : (isDay ? 5.4977875f : (oddBand ? 3.926991f : 2.3561945f));
        return new Wind(intensity, (float)Math.toDegrees(angle += random.nextFloat() * 0.2f - 0.1f));
    }

    protected Random seededRandom(long day, long salt) {
        long seed = LinearCongruentialGenerator.m_13972_((long)129341623413L, (long)day);
        seed = LinearCongruentialGenerator.m_13972_((long)seed, (long)salt);
        return new Random(seed);
    }
}

