/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.events.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.commands.ATLCommands;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.events.common.ModEvent;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.feature.server.mods.minecraft.DebugThreadsHooks;
import dev.uncandango.alltheleaks.report.ReportManager;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="alltheleaks", value={Dist.DEDICATED_SERVER})
public class GameBusEvent {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ReportManager.tick();
        }
    }

    @SubscribeEvent
    public static void registerServerCommands(RegisterCommandsEvent event) {
        ATLCommands.registerServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!ReportManager.isRegistered("min_memory_tracker")) {
            ReportManager.registerTask("min_memory_tracker", 1, MemoryMonitor.Statistics::evaluateMemory);
        }
    }

    @SubscribeEvent
    public static void printNonDaemonThreads(ServerStoppedEvent event) {
        AtomicBoolean isFirstRun = new AtomicBoolean(true);
        Thread thread = new Thread(() -> {
            while (true) {
                Set<Thread> threads;
                List<Thread> nonDaemonThreads;
                try {
                    if (isFirstRun.get()) {
                        Thread.sleep(10000L);
                    } else {
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                if ((nonDaemonThreads = (threads = Thread.getAllStackTraces().keySet()).stream().filter(t -> !t.isDaemon()).filter(t -> !t.getName().equals("DestroyJavaVM")).toList()).isEmpty()) continue;
                nonDaemonThreads.forEach(DebugThreadsHooks::prettyPrintEvent);
                if (!isFirstRun.get()) continue;
                if (!ATLProperties.get().debugThreadsStuck) {
                    AllTheLeaks.LOGGER.warn("If you did *NOT CRASH*, consider activating \"debugThreadsStuck\" at \"config/alltheleaks.json\" to find where those stuck threads are from");
                }
                if (ModEvent.reports > 0) {
                    AllTheLeaks.LOGGER.warn("Seems like you crashed and the server got stuck, you might need to terminate the process!");
                } else {
                    AllTheLeaks.LOGGER.warn("Seems like server is stuck while trying to close. Read messages above about stuck threads!");
                }
                isFirstRun.set(false);
            }
        });
        thread.setName("Stuck Thread Watcher");
        thread.setDaemon(true);
        thread.start();
    }
}

