/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.leaks.common.mods.forge;

import com.google.common.base.Stopwatch;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.Jar;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.utils.ReflectionHelper;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

@Issue(modId="forge", issueId="eventbus-#39", versionRange="[47.2,)", description="Regenerate listeners cache on server stopped")
public class Issue39 {
    public static final MethodHandle GET_LISTENERS;
    public static final VarHandle ALL_LISTS;
    public static final VarHandle LISTS;
    public static final Class<?> LISTENER_LIST_INST_CLASS;

    public Issue39() {
        IEventBus gameBus = MinecraftForge.EVENT_BUS;
        try {
            Jar eventBusJar = (Jar)SecureJar.from((Path[])new Path[]{Path.of(gameBus.getClass().getProtectionDomain().getCodeSource().getLocation().toURI())});
            String busVersion = eventBusJar.getManifest().getAttributes("net/minecraftforge/eventbus/service/").getValue("Implementation-Version");
            eventBusJar.getRootPath().getFileSystem().close();
            DefaultArtifactVersion version = new DefaultArtifactVersion(busVersion);
            VersionRange range = VersionRange.createFromVersionSpec((String)"[6.2.26,)");
            if (range.containsVersion((ArtifactVersion)version)) {
                AllTheLeaks.LOGGER.debug("Skipping memory leak fix on Event Bus: version range {} contains version {}", (Object)range, (Object)version);
                return;
            }
        }
        catch (IOException | URISyntaxException | InvalidVersionSpecificationException e) {
            AllTheLeaks.LOGGER.error("Error while querying version of event bus", e);
            return;
        }
        gameBus.addListener(EventPriority.LOWEST, this::rebuildListenersCache);
    }

    private void rebuildListenersCache(ServerStoppedEvent event) {
        try {
            Stopwatch watch = Stopwatch.createStarted();
            List listeners = ALL_LISTS.get();
            for (ListenerList listener : listeners) {
                Object[] list;
                for (Object ev : list = LISTS.get(listener)) {
                    GET_LISTENERS.invoke(ev);
                }
            }
            AllTheLeaks.LOGGER.debug("Rebuild listeners cache took {}ms", (Object)watch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Throwable e) {
            AllTheLeaks.LOGGER.error("Error while trying to rebuild listeners cache", e);
        }
    }

    static {
        ALL_LISTS = ReflectionHelper.getFieldFromClass(ListenerList.class, "allLists", List.class, true);
        LISTENER_LIST_INST_CLASS = ReflectionHelper.getPrivateClass(ListenerList.class, "net.minecraftforge.eventbus.ListenerList$ListenerListInst");
        GET_LISTENERS = ReflectionHelper.getMethodFromClass(LISTENER_LIST_INST_CLASS, "getListeners", MethodType.methodType(IEventListener.class.arrayType()), false);
        LISTS = ReflectionHelper.getFieldFromClass(ListenerList.class, "lists", LISTENER_LIST_INST_CLASS.arrayType(), false);
    }
}

