/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SmallShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final EnumProperty<SlabType> HALF = ModBlockStateProperties.HALF;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP_AABB_NORTH = Block.m_49796_((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB_NORTH = Block.m_49796_((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape DOUBLE_AABB_NORTH = Shapes.m_83110_((VoxelShape)TOP_AABB_NORTH, (VoxelShape)BOTTOM_AABB_NORTH);
    protected static final VoxelShape TOP_AABB_EAST = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_AABB_EAST = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape DOUBLE_AABB_EAST = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape TOP_AABB_SOUTH = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_AABB_SOUTH = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape DOUBLE_AABB_SOUTH = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape TOP_AABB_WEST = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_AABB_WEST = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.WEST);
    protected static final VoxelShape DOUBLE_AABB_WEST = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.WEST);

    public SmallShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_(HALF, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemStack = useContext.m_43722_();
        SlabType slabType = (SlabType)state.m_61143_(HALF);
        if (slabType == SlabType.DOUBLE || !itemStack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!useContext.m_7058_()) {
            return true;
        }
        boolean bl = useContext.m_43720_().f_82480_ - (double)useContext.m_8083_().m_123342_() > 0.5;
        Direction direction = useContext.m_43719_();
        if (slabType == SlabType.BOTTOM) {
            return direction == Direction.UP || bl && direction.m_122434_().m_122479_();
        }
        return direction == Direction.DOWN || !bl && direction.m_122434_().m_122479_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return InteractionResult.PASS;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get2D(pos, hit.m_82450_(), Direction.UP, facing.m_122427_(), 2, 2);
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (!level.f_46443_ && shelfBE.placeItem(player.m_150110_().f_35937_ ? stack.m_41777_() : stack, slot)) {
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (shelfBE.removeItem(slot, player, level)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
            Containers.m_19010_((Level)level, (BlockPos)pos, shelfBE.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.m_61143_(TYPE));
        SlabType half = (SlabType)state.m_61143_(HALF);
        if (direction == Direction.NORTH) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_NORTH;
                case SlabType.DOUBLE -> DOUBLE_AABB_NORTH;
                default -> BOTTOM_AABB_NORTH;
            };
        }
        if (direction == Direction.EAST) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_EAST;
                case SlabType.DOUBLE -> DOUBLE_AABB_EAST;
                default -> BOTTOM_AABB_EAST;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_SOUTH;
                case SlabType.DOUBLE -> DOUBLE_AABB_SOUTH;
                default -> BOTTOM_AABB_SOUTH;
            };
        }
        return switch (half) {
            case SlabType.TOP -> TOP_AABB_WEST;
            case SlabType.DOUBLE -> DOUBLE_AABB_WEST;
            default -> BOTTOM_AABB_WEST;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        BlockState stateExisting = context.m_43725_().m_8055_(clickedPos);
        if (stateExisting.m_60713_((Block)this)) {
            return (BlockState)stateExisting.m_61124_(HALF, (Comparable)SlabType.DOUBLE);
        }
        boolean waterlogged = context.m_43725_().m_6425_(clickedPos).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        Direction direction = context.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.m_43720_().f_82480_ - (double)clickedPos.m_123342_() > 0.5) ? state : (BlockState)state.m_61124_(HALF, (Comparable)SlabType.TOP);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean sideR;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        BlockState above = level.m_8055_(currentPos.m_7494_());
        if (direction == Direction.UP && above.m_60783_((BlockGetter)level, currentPos, Direction.DOWN) && !above.m_60771_((BlockGetter)level, currentPos.m_7494_(), CollisionContext.m_82749_()).m_83281_() && (blockEntity = level.m_7702_(currentPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockEntity;
            shelfBE.removeAllItems();
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction dirL = facing.m_122427_();
        Direction dirR = facing.m_122428_();
        if (direction != dirL && direction != dirR) {
            return state;
        }
        BlockState stateL = level.m_8055_(currentPos.m_121945_(dirL));
        BlockState stateR = level.m_8055_(currentPos.m_121945_(dirR));
        boolean sideL = stateL.m_60734_() instanceof SmallShelfBlock && stateL.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        boolean bl = sideR = stateR.m_60734_() instanceof SmallShelfBlock && stateR.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, HALF, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

