/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.flywheel_bearing;

import com.kipti.bnb.content.flywheel_bearing.FlywheelBearingBlock;
import com.kipti.bnb.content.flywheel_bearing.contraption.InertControlledContraptionEntity;
import com.kipti.bnb.content.flywheel_bearing.mechanics.FlywheelMovementMechanics;
import com.kipti.bnb.mixin_accessor.FlywheelAccessibleKineticNetwork;
import com.kipti.bnb.registry.BnbConfigs;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FlywheelBearingBlockEntity
extends GeneratingKineticBlockEntity
implements IControlContraption,
IDisplayAssemblyExceptions {
    protected AssemblyException lastException;
    protected InertControlledContraptionEntity movedContraption;
    protected boolean checkAssemblyNextTick;
    protected float clientAngleDiff;
    protected boolean running;
    protected float clientFlywheelAbsorptionCapacityInNetwork;
    protected float clientFlywheelReleaseCapacityInNetwork;
    protected int lastGeneratorDirection = 1;
    protected FlywheelMovementMechanics flywheelMovement = new FlywheelMovementMechanics();

    public FlywheelBearingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.lazyTickRate = 5;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.running) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        Lang.builder((String)"bits_n_bobs").add(Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.flywheel_stats")).forGoggles(tooltip);
        Lang.builder((String)"bits_n_bobs").add(Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.builder((String)"bits_n_bobs").add(Component.m_237113_((String)(this.flywheelMovement.formatAngularMass() + " "))).style(ChatFormatting.AQUA).add(this.flywheelMovement.getAngularMassDescription().m_6881_().m_130940_(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        if (((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            Lang.builder((String)"bits_n_bobs").add(Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.stored_stress")).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float currentStoredStress = this.flywheelMovement.currentStoredStressTicks;
            float lastStoredStress = this.flywheelMovement.lastStoredStressTicks;
            float maxStoredStress = this.flywheelMovement.getMaxStoredStressTicks();
            int direction = Float.compare(currentStoredStress, lastStoredStress);
            int changeStrength = Mth.m_14045_((int)Math.round(1500.0f * Math.abs(currentStoredStress - lastStoredStress) / maxStoredStress), (int)1, (int)5);
            int maxBars = 100;
            int filledBars = Mth.m_14045_((int)Math.round(currentStoredStress / maxStoredStress * 100.0f), (int)0, (int)100);
            Lang.builder((String)"bits_n_bobs").add(Component.m_237113_((String)"|".repeat(filledBars))).style(ChatFormatting.AQUA).add(Component.m_237113_((String)"|".repeat(100 - filledBars)).m_130940_(ChatFormatting.DARK_GRAY)).add(Component.m_237113_((String)(direction == 0 ? "" : (direction > 0 ? " " + ">".repeat(changeStrength) : " " + "<".repeat(changeStrength)))).m_130940_(direction == 0 ? ChatFormatting.DARK_GRAY : ChatFormatting.AQUA)).forGoggles(tooltip, 1);
            Lang.builder((String)"bits_n_bobs").add(Component.m_237113_((String)String.format("%.1fsut", Float.valueOf(currentStoredStress)))).style(ChatFormatting.AQUA).add(Component.m_237113_((String)String.format("/%.1fsut ", Float.valueOf(maxStoredStress))).m_130940_(ChatFormatting.GRAY)).add((!this.flywheelMovement.canProvideStress() ? Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.empty") : (this.flywheelMovement.canReceiveStress() ? Component.m_237119_() : Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.full"))).m_130940_(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            Lang.builder((String)"bits_n_bobs").add(Component.m_237115_((String)"tooltip.bits_n_bobs.flywheel_bearing.kinetic_transfer")).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.builder((String)"bits_n_bobs").add(Component.m_237113_((String)String.format("%.1fsu", Float.valueOf(this.flywheelMovement.kineticTransfer)))).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.addGenerationAsZeroIfNeeded(tooltip);
        return true;
    }

    private void addGenerationAsZeroIfNeeded(List<Component> tooltip) {
        if (!IRotate.StressImpact.isEnabled()) {
            return;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (!Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return;
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)0.0).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void remove() {
        if (!this.f_58857_.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128350_("NetworkFlywheelAbsorptionCapacity", this.hasNetwork() ? this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressAbsoptionCapacity() : 0.0f);
        compound.m_128350_("NetworkFlywheelReleaseCapacity", this.hasNetwork() ? this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressReleaseCapacity() : 0.0f);
        compound.m_128405_("LastGeneratorDirection", this.lastGeneratorDirection);
        this.flywheelMovement.writeAdditional(compound);
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        if (clientPacket) {
            this.clientFlywheelAbsorptionCapacityInNetwork = compound.m_128457_("NetworkFlywheelAbsorptionCapacity");
            this.clientFlywheelReleaseCapacityInNetwork = compound.m_128457_("NetworkFlywheelReleaseCapacity");
        }
        float angleBefore = this.flywheelMovement.angle;
        this.running = compound.m_128471_("Running");
        this.lastGeneratorDirection = compound.m_128451_("LastGeneratorDirection");
        this.flywheelMovement.readAdditional(compound, clientPacket);
        this.lastException = AssemblyException.read((CompoundTag)compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (!this.running) {
            this.flywheelMovement.clientAngle = null;
            this.movedContraption = null;
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.flywheelMovement.prevClientAngle, (float)(this.flywheelMovement.clientAngle == null ? this.flywheelMovement.angle : this.flywheelMovement.clientAngle.floatValue()));
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks, (float)this.flywheelMovement.prevClientAngle, (float)(this.flywheelMovement.clientAngle == null ? this.flywheelMovement.angle : this.flywheelMovement.clientAngle.floatValue()));
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.checkAssemblyNextTick = true;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.flywheelMovement.angle = Math.round(this.flywheelMovement.angle);
                this.applyRotation();
            }
            this.movedContraption.getContraption().stop(this.f_58857_);
        }
    }

    public float getAngularSpeed() {
        float speed = FlywheelBearingBlockEntity.convertToAngular((float)this.flywheelMovement.angularVelocity);
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public void assemble() {
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof FlywheelBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)FlywheelBearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(false, direction);
        try {
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.movedContraption = InertControlledContraptionEntity.create(this.f_58857_, this, (Contraption)contraption);
        BlockPos anchor = this.f_58858_.m_121945_(direction);
        this.movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        this.movedContraption.setRotationAxis(direction.m_122434_());
        this.f_58857_.m_7967_((Entity)this.movedContraption);
        this.flywheelMovement.assemble(this, contraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        this.running = true;
        this.flywheelMovement.zero();
        this.sendData();
        this.updateGeneratedRotation();
        this.updateFlywheelStressesInNetwork();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.flywheelMovement.zero();
        if (this.movedContraption != null) {
            this.movedContraption.setAngle(0.0f);
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.updateFlywheelStressesInNetwork();
        this.checkAssemblyNextTick = false;
        this.sendData();
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!ICogWheel.isLargeCog((BlockState)state)) {
            return super.addPropagationLocations(block, state, neighbours);
        }
        BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (offset.m_123331_((Vec3i)BlockPos.f_121853_) == 2.0) {
                neighbours.add(this.f_58858_.m_121955_((Vec3i)offset));
            }
        });
        return neighbours;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.f_58857_.f_46443_ && this.checkAssemblyNextTick) {
            this.checkAssemblyNextTick = false;
            if (this.running) {
                if (this.speed == 0.0f && (this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.f_58857_);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            this.flywheelMovement.tickForStorageBehaviour(this);
        } else {
            this.flywheelMovement.tick(this);
        }
        this.applyRotation();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && this.running && !this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.f_58857_.f_46443_ ? this.flywheelMovement.clientAngle.floatValue() : this.flywheelMovement.angle);
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_());
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.running) {
            return false;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof BearingBlock)) {
            return false;
        }
        BlockState attachedState = this.f_58857_.m_8055_(this.f_58858_.m_121945_((Direction)state.m_61143_((Property)BearingBlock.FACING)));
        if (attachedState.m_247087_()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"hint.empty_bearing", (Object[])new Object[0]);
        return true;
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.m_58900_();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!(contraption instanceof InertControlledContraptionEntity)) {
            return;
        }
        InertControlledContraptionEntity inertControlledContraptionEntity = (InertControlledContraptionEntity)contraption;
        if (!blockState.m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = inertControlledContraptionEntity;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_121945_((Direction)blockState.m_61143_((Property)BearingBlock.FACING));
        this.movedContraption.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        this.running = true;
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    public BlockPos getBlockPosition() {
        return this.f_58858_;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public float getFlywheelStressDelta() {
        float flywheelAbsorptionCapacityInNetwork;
        if (!this.hasNetwork() || !((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        float f = this.f_58857_ == null ? 0.0f : (flywheelAbsorptionCapacityInNetwork = this.f_58857_.f_46443_ ? this.clientFlywheelAbsorptionCapacityInNetwork : this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressAbsoptionCapacity());
        float flywheelReleaseCapacityInNetwork = this.f_58857_ == null ? 0.0f : (this.f_58857_.f_46443_ ? this.clientFlywheelReleaseCapacityInNetwork : this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressReleaseCapacity());
        float stressDifferenceInNetwork = this.capacity - flywheelReleaseCapacityInNetwork - this.stress;
        float flywheelAbsorptionStressCapacity = this.getFlywheelStressAbsorptionCapacity();
        float flywheelReleaseStressCapacity = this.getFlywheelStressReleaseCapacity();
        if (stressDifferenceInNetwork > 0.0f) {
            if (flywheelAbsorptionCapacityInNetwork == 0.0f) {
                return 0.0f;
            }
            return flywheelAbsorptionStressCapacity / flywheelAbsorptionCapacityInNetwork * stressDifferenceInNetwork;
        }
        if (flywheelReleaseCapacityInNetwork == 0.0f) {
            return 0.0f;
        }
        return flywheelReleaseStressCapacity / flywheelReleaseCapacityInNetwork * stressDifferenceInNetwork;
    }

    protected FlywheelAccessibleKineticNetwork getOrCreateFlywheelNetwork() {
        return (FlywheelAccessibleKineticNetwork)this.getOrCreateNetwork();
    }

    public float getFlywheelStressAbsorptionCapacity() {
        return this.running ? this.flywheelMovement.getFlywheelStressCapacity() : 0.0f;
    }

    public void updateFlywheelStressesInNetwork() {
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue() || !this.hasNetwork()) {
            return;
        }
        this.getOrCreateFlywheelNetwork().bits_n_bobs$updateFlywheelStresses();
    }

    public float getGeneratedSpeed() {
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        float currentSpeed = this.getTheoreticalSpeed();
        if (currentSpeed != 0.0f) {
            int direction;
            int n = direction = currentSpeed > 0.0f ? 1 : -1;
            if (direction != this.lastGeneratorDirection) {
                this.lastGeneratorDirection = direction;
                this.sendData();
            }
        }
        return this.flywheelMovement.canProvideStress() ? (float)(this.lastGeneratorDirection * 8) : 0.0f;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        this.lastCapacityProvided = capacity = this.getFlywheelStressReleaseCapacity();
        float currentSpeed = this.getGeneratedSpeed();
        return currentSpeed == 0.0f ? capacity : capacity / Math.abs(currentSpeed);
    }

    public float getFlywheelStressReleaseCapacity() {
        return this.flywheelMovement.canProvideStress() ? this.flywheelMovement.getMaxTransferCapacity() : 0.0f;
    }

    public void updateFlywheelStressesFromNetwork() {
        this.sendData();
    }
}

