/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.content.nixie.foundation.DoubleOrientedDirections;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class DoubleOrientedBlockModel
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<DoubleOrientedModelData> DOUBLE_ORIENTED_PROPERTY = new ModelProperty();

    public DoubleOrientedBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        DoubleOrientedModelData data = new DoubleOrientedModelData();
        Direction up = (Direction)state.m_61143_((Property)GenericNixieDisplayBlock.f_52588_);
        Direction front = (Direction)state.m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION);
        Matrix4f rotation = DoubleOrientedBlockModel.getRotation(up, front);
        data.setRotation(rotation);
        return ModelData.builder().with(DOUBLE_ORIENTED_PROPERTY, (Object)data).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        if (data.has(DOUBLE_ORIENTED_PROPERTY)) {
            DoubleOrientedModelData doubleOrientedModelData = (DoubleOrientedModelData)data.get(DOUBLE_ORIENTED_PROPERTY);
            assert (doubleOrientedModelData != null);
            PoseStack transformStack = new PoseStack();
            transformStack.m_85837_(0.5, 0.5, 0.5);
            transformStack.m_252931_(doubleOrientedModelData.getRotation());
            transformStack.m_85837_(-0.5, -0.5, -0.5);
            return new ArrayList<BakedQuad>(this.transformQuads(super.getQuads(state, side, rand, data, renderType), transformStack));
        }
        return Collections.emptyList();
    }

    public static Matrix4f getRotation(Direction upDir, Direction frontDir) {
        Direction leftDir = DoubleOrientedDirections.getLeft(upDir, frontDir);
        return new Matrix4f((float)leftDir.m_122429_(), (float)leftDir.m_122430_(), (float)leftDir.m_122431_(), 0.0f, (float)upDir.m_122429_(), (float)upDir.m_122430_(), (float)upDir.m_122431_(), 0.0f, (float)(-frontDir.m_122429_()), (float)(-frontDir.m_122430_()), (float)(-frontDir.m_122431_()), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    private List<BakedQuad> transformQuads(List<BakedQuad> quads, PoseStack poseStack) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            int[] vertices = quad.m_111303_();
            int[] transformedVertices = Arrays.copyOf(vertices, vertices.length);
            Vec3 quadNormal = Vec3.m_82528_((Vec3i)quad.m_111306_().m_122436_());
            Vector3f quadNormalJoml = pose.transformDirection((float)quadNormal.f_82479_, (float)quadNormal.f_82480_, (float)quadNormal.f_82481_, new Vector3f());
            for (int i = 0; i < vertices.length / BakedQuadHelper.VERTEX_STRIDE; ++i) {
                Vec3 vertex = BakedQuadHelper.getXYZ((int[])vertices, (int)i);
                Vec3 normal = BakedQuadHelper.getNormalXYZ((int[])vertices, (int)i);
                Vector3f vertexJoml = pose.transformPosition((float)vertex.f_82479_, (float)vertex.f_82480_, (float)vertex.f_82481_, new Vector3f());
                Vector3f normalJoml = pose.transformDirection((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_, new Vector3f());
                BakedQuadHelper.setXYZ((int[])transformedVertices, (int)i, (Vec3)new Vec3((double)vertexJoml.x, (double)vertexJoml.y, (double)vertexJoml.z));
                BakedQuadHelper.setNormalXYZ((int[])transformedVertices, (int)i, (Vec3)new Vec3((double)normalJoml.x, (double)normalJoml.y, (double)normalJoml.z));
            }
            Direction newNormal = Direction.m_122372_((float)quadNormalJoml.x, (float)quadNormalJoml.y, (float)quadNormalJoml.z).m_122424_();
            transformedQuads.add(new BakedQuad(transformedVertices, quad.m_111305_(), newNormal, quad.m_173410_(), false));
        }
        return transformedQuads;
    }

    private static class DoubleOrientedModelData {
        Matrix4f rotation;

        private DoubleOrientedModelData() {
        }

        public Matrix4f getRotation() {
            return this.rotation;
        }

        public void setRotation(Matrix4f rotation) {
            this.rotation = rotation;
        }
    }
}

