/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.ability;

import com.furiusmax.bjornlib.BjornLibImpl;
import com.furiusmax.bjornlib.ability.AbilityType;
import com.furiusmax.bjornlib.capability.IPlayerAbilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class Ability {
    public final AbilityType type;
    private Player player;
    public int level = 0;
    public int maxLevel = 0;
    public float cooldownTimer = 0.0f;
    public float cooldown = 0.0f;
    public float cost = 0.0f;

    public Ability(AbilityType type, Player pl, int maxLvl) {
        this.type = type;
        this.player = pl;
        this.maxLevel = maxLvl;
        this.cost = type.getCost();
    }

    public void tick() {
        if (this.cooldownTimer > 0.0f) {
            this.cooldownTimer -= 1.0f;
        }
    }

    public boolean canCastAbility() {
        return this.cooldownTimer <= 0.0f;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player pl) {
        this.player = pl;
    }

    public Ability setLevel(int i) {
        this.level = i;
        return this;
    }

    public float getCost() {
        return this.cost;
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void levelUp(IPlayerAbilities playerAbilities, boolean sendEvent) {
        if (this.type.onLevelUp(playerAbilities, this)) {
            ++this.level;
            if (sendEvent) {
                BjornLibImpl.INSTANCE.fireAbilityEvent(this.getPlayer(), playerAbilities, this.type, BjornLibImpl.SkillEvent.UPDATE);
            }
        }
    }

    public void readTag(CompoundTag tag) {
        this.level = tag.m_128451_("lvl");
        this.maxLevel = tag.m_128451_("maxLvl");
        this.cooldownTimer = tag.m_128457_("cooldown");
    }

    public void writeTag(CompoundTag tag) {
        tag.m_128405_("lvl", this.level);
        tag.m_128405_("maxLvl", this.maxLevel);
        tag.m_128350_("cooldown", this.cooldownTimer);
    }
}

