/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.ability;

import com.furiusmax.bjornlib.ability.Ability;
import com.furiusmax.bjornlib.capability.IPlayerAbilities;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class AbilityType {
    private final String name;
    private final float cost;
    private final int maxLevel;
    private final AbilityType parent;
    private final AbilityCastType castType;
    private String description;
    public static final AbilityType EMPTY = new AbilityType("empty", 0, 0.0f, AbilityCastType.PASSIVE, null);

    public AbilityType(String name, int maxLevel, float cost, AbilityCastType castType, AbilityType parent) {
        this.name = name;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.castType = castType;
        this.parent = parent;
        this.description = name + ".description";
    }

    public AbilityType(String name, int maxLevel, float cost, AbilityCastType castType) {
        this.name = name;
        this.maxLevel = maxLevel;
        this.cost = cost;
        this.castType = castType;
        this.parent = null;
        this.description = name + ".description";
    }

    public String getName() {
        return this.name;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public float getCost() {
        return this.cost;
    }

    public AbilityCastType getCastType() {
        return this.castType;
    }

    public Component getDescription(int lvl) {
        return this.getComponentPerLevel(lvl);
    }

    private Component getComponentPerLevel(int i) {
        int level = i == 0 ? 1 : i;
        return Component.m_237115_((String)(this.description + ".lvl_" + level));
    }

    public boolean onLevelUp(IPlayerAbilities playerAbilities, Ability skill) {
        if (playerAbilities == null) {
            return false;
        }
        Optional parent = playerAbilities.getAbility(skill.type.parent);
        if (parent.isPresent() && ((Ability)parent.get()).level > 0 && skill.getLevel() < skill.getMaxLevel()) {
            return true;
        }
        return !parent.isPresent() && skill.getLevel() < skill.getMaxLevel();
    }

    public Ability createAbility(Player player, int maxLvl) {
        return new Ability(this, player, maxLvl);
    }

    public AbilityType getParent() {
        return this.parent;
    }

    public static enum AbilityCastType {
        PASSIVE("passive"),
        SELF("self"),
        VIEWING("viewing"),
        BLOCK_TARGET("block_target"),
        ENTITY_TARGET("entity_target");

        public String name;

        private AbilityCastType(String name) {
            this.name = name;
        }
    }
}

