/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class GenericParticleData
implements ParticleOptions {
    public float r1 = 1.0f;
    public float g1 = 1.0f;
    public float b1 = 1.0f;
    public float a1 = 1.0f;
    public float r2 = 1.0f;
    public float g2 = 1.0f;
    public float b2 = 1.0f;
    public float a2 = 0.0f;
    public float scale1 = 1.0f;
    public float scale2 = 0.0f;
    public int lifetime = 20;
    public float spin = 0.0f;
    public boolean gravity = false;
    public String ownerUUID = "";
    ParticleType<?> type;
    public static final ParticleOptions.Deserializer<GenericParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GenericParticleData>(){

        public GenericParticleData fromCommand(ParticleType<GenericParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r1 = reader.readFloat();
            reader.expect(' ');
            float g1 = reader.readFloat();
            reader.expect(' ');
            float b1 = reader.readFloat();
            reader.expect(' ');
            float a1 = reader.readFloat();
            reader.expect(' ');
            float r2 = reader.readFloat();
            reader.expect(' ');
            float g2 = reader.readFloat();
            reader.expect(' ');
            float b2 = reader.readFloat();
            reader.expect(' ');
            float a2 = reader.readFloat();
            reader.expect(' ');
            float scale1 = reader.readFloat();
            reader.expect(' ');
            float scale2 = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float spin = reader.readFloat();
            reader.expect(' ');
            boolean gravity = reader.readBoolean();
            reader.expect(' ');
            String ownerUUID = reader.readString();
            GenericParticleData data = new GenericParticleData(type);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.scale1 = scale1;
            data.scale2 = scale2;
            data.lifetime = lifetime;
            data.spin = spin;
            data.gravity = gravity;
            data.ownerUUID = ownerUUID;
            return data;
        }

        public GenericParticleData fromNetwork(ParticleType<GenericParticleData> type, FriendlyByteBuf buf) {
            float r1 = buf.readFloat();
            float g1 = buf.readFloat();
            float b1 = buf.readFloat();
            float a1 = buf.readFloat();
            float r2 = buf.readFloat();
            float g2 = buf.readFloat();
            float b2 = buf.readFloat();
            float a2 = buf.readFloat();
            float scale1 = buf.readFloat();
            float scale2 = buf.readFloat();
            int lifetime = buf.readInt();
            float spin = buf.readFloat();
            boolean gravity = buf.readBoolean();
            String ownerUUID = buf.m_130277_();
            GenericParticleData data = new GenericParticleData(type);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.scale1 = scale1;
            data.scale2 = scale2;
            data.lifetime = lifetime;
            data.spin = spin;
            data.gravity = gravity;
            data.ownerUUID = ownerUUID;
            return data;
        }
    };

    public static Codec<GenericParticleData> codecFor(ParticleType<?> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(data -> Float.valueOf(data.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(data -> Float.valueOf(data.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(data -> Float.valueOf(data.b1)), (App)Codec.FLOAT.fieldOf("a1").forGetter(data -> Float.valueOf(data.a1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(data -> Float.valueOf(data.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(data -> Float.valueOf(data.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(data -> Float.valueOf(data.b2)), (App)Codec.FLOAT.fieldOf("a2").forGetter(data -> Float.valueOf(data.a2)), (App)Codec.FLOAT.fieldOf("scale1").forGetter(data -> Float.valueOf(data.scale1)), (App)Codec.FLOAT.fieldOf("scale2").forGetter(data -> Float.valueOf(data.scale2)), (App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Codec.FLOAT.fieldOf("spin").forGetter(data -> Float.valueOf(data.spin)), (App)Codec.BOOL.fieldOf("gravity").forGetter(data -> data.gravity), (App)Codec.STRING.fieldOf("ownerUUID").forGetter(data -> data.ownerUUID)).apply((Applicative)instance, (r1, g1, b1, a1, r2, g2, b2, a2, scale1, scale2, lifetime, spin, gravity, ownerUUID) -> {
            GenericParticleData data = new GenericParticleData(type);
            data.r1 = r1.floatValue();
            data.g1 = g1.floatValue();
            data.b1 = b1.floatValue();
            data.a1 = a1.floatValue();
            data.r2 = r2.floatValue();
            data.g2 = g2.floatValue();
            data.b2 = b2.floatValue();
            data.a2 = a2.floatValue();
            data.scale1 = scale1.floatValue();
            data.scale2 = scale2.floatValue();
            data.lifetime = lifetime;
            data.spin = spin.floatValue();
            data.gravity = gravity;
            data.ownerUUID = ownerUUID;
            return data;
        }));
    }

    public GenericParticleData(ParticleType<?> type) {
        this.type = type;
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public String m_5942_() {
        return this.getClass().getSimpleName() + ":internal";
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r1);
        buffer.writeFloat(this.g1);
        buffer.writeFloat(this.b1);
        buffer.writeFloat(this.a1);
        buffer.writeFloat(this.r2);
        buffer.writeFloat(this.g2);
        buffer.writeFloat(this.b2);
        buffer.writeFloat(this.a2);
        buffer.writeFloat(this.scale1);
        buffer.writeFloat(this.scale2);
        buffer.writeInt(this.lifetime);
        buffer.writeFloat(this.spin);
        buffer.writeBoolean(this.gravity);
        buffer.m_130070_(this.ownerUUID);
    }
}

