/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.forge;

import com.furiusmax.bjornlib.forge.Networking;
import com.furiusmax.bjornlib.forge.SyncPlayerMorphToClient;
import com.furiusmax.bjornlib.morph.AbstractEntityMorph;
import com.furiusmax.bjornlib.morph.AbstractPlayerMorph;
import com.furiusmax.bjornlib.morph.IMorph;
import com.furiusmax.bjornlib.registry.MorphRegistry;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="bjornlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerMorphCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<PlayerMorphCapability> MORPH = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerMorphCapability>(){});
    private IMorph morph;

    public IMorph getMorph() {
        return this.morph;
    }

    public void setMorph(IMorph morph) {
        this.morph = morph;
    }

    public void setMorph(IMorph morph, Player player) {
        if (this.morph != null) {
            this.morph.unMorph(player);
        }
        this.morph = morph;
        this.morph.morph(player);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return MORPH.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.morph != null) {
            CompoundTag morphTag = new CompoundTag();
            String id = this.morph.id().toString();
            CompoundTag morphSavedTag = this.morph.saveData(new CompoundTag());
            morphTag.m_128359_("morphId", id);
            morphTag.m_128365_("morphSavedTag", (Tag)morphSavedTag);
            tag.m_128365_("morph", (Tag)morphTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("morph")) {
            CompoundTag morphTag = tag.m_128469_("morph");
            ResourceLocation id = new ResourceLocation(morphTag.m_128461_("morphId"));
            CompoundTag morphSavedTag = morphTag.m_128469_("morphSavedTag");
            IMorph mrp = MorphRegistry.getMorph(id).clone();
            mrp.readData(morphSavedTag);
            this.morph = mrp;
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("bjornlib", "morph"), (ICapabilityProvider)new PlayerMorphCapability());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        event.getEntity().m_21051_(Attributes.f_22276_).m_22100_(oldPlayer.m_21051_(Attributes.f_22276_).m_22115_());
        event.getOriginal().getCapability(MORPH).ifPresent(oldCap -> event.getEntity().getCapability(MORPH).ifPresent(newCap -> newCap.deserializeNBT(oldCap.serializeNBT())));
        event.getOriginal().invalidateCaps();
    }

    public static void synchronise(Player player) {
        if (player != null && !player.m_20193_().f_46443_) {
            AttributeInstance entityMaxHealthAttribute = player.m_21051_(Attributes.f_22276_);
            ClientboundUpdateAttributesPacket packet = new ClientboundUpdateAttributesPacket(player.m_19879_(), Collections.singleton(entityMaxHealthAttribute));
            ((ServerLevel)player.m_20193_()).m_7726_().m_8394_((Entity)player, (Packet)packet);
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().f_46443_) {
            PlayerMorphCapability capability = (PlayerMorphCapability)event.getEntity().getCapability(MORPH).orElse(null);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncPlayerMorphToClient(capability.serializeNBT(), event.getEntity().m_20148_()));
            PlayerMorphCapability.synchronise(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerJoin(TickEvent.PlayerTickEvent event) {
        PlayerMorphCapability capability = (PlayerMorphCapability)event.player.getCapability(MORPH).orElse(null);
        if (capability == null) {
            return;
        }
        if (capability.morph != null) {
            capability.morph.tick(event.player);
        }
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PlayerMorphCapability capability = (PlayerMorphCapability)event.getEntity().getCapability(MORPH).orElse(null);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncPlayerMorphToClient(capability.serializeNBT(), event.getEntity().m_20148_()));
            PlayerMorphCapability.synchronise(event.getEntity());
            event.getEntity().m_5634_((float)event.getEntity().m_21051_(Attributes.f_22276_).m_22135_());
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
        if (event.getEntity() instanceof Player && !event.getEntity().m_9236_().f_46443_) {
            PlayerMorphCapability capability = (PlayerMorphCapability)event.getEntity().getCapability(MORPH).orElse(null);
            if (capability == null) {
                return;
            }
            if (capability.morph != null) {
                capability.morph.morph(event.getEntity());
            }
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncPlayerMorphToClient(capability.serializeNBT(), event.getTarget().m_20148_()));
            PlayerMorphCapability.synchronise(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!event.getEntity().m_9236_().f_46443_) {
                PlayerMorphCapability capability = (PlayerMorphCapability)event.getEntity().getCapability(MORPH).orElse(null);
                if (capability == null) {
                    return;
                }
                if (capability.morph != null) {
                    capability.morph.morph(event.getEntity());
                }
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SyncPlayerMorphToClient(capability.serializeNBT(), event.getEntity().m_20148_()));
                PlayerMorphCapability.synchronise(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void changeSize(EntityEvent.Size event) {
        Player player;
        PlayerMorphCapability morphCapability;
        Entity entity;
        if (event.getEntity().isAddedToWorld() && (entity = event.getEntity()) instanceof Player && (morphCapability = (PlayerMorphCapability)(player = (Player)entity).getCapability(MORPH).orElse(null)) != null && morphCapability.getMorph() != null && morphCapability.getMorph() instanceof AbstractEntityMorph) {
            event.setNewSize(((AbstractEntityMorph)morphCapability.getMorph()).getEntityMorph().m_6095_().m_20680_(), true);
            event.setNewEyeHeight(((AbstractEntityMorph)morphCapability.getMorph()).getEntityMorph().m_20192_());
        }
    }

    @Mod.EventBusSubscriber(modid="bjornlib", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class NameTagManager {
        NameTagManager() {
        }

        @SubscribeEvent
        public static void renderNameTag(RenderNameTagEvent event) {
            PlayerInfo playerinfo;
            AbstractPlayerMorph playerMorph;
            IMorph iMorph;
            Player player;
            PlayerMorphCapability morphCapability;
            Entity entity = event.getEntity();
            if (entity instanceof Player && (morphCapability = (PlayerMorphCapability)(player = (Player)entity).getCapability(MORPH).orElse(null)) != null && morphCapability.getMorph() != null && (iMorph = morphCapability.getMorph()) instanceof AbstractPlayerMorph && (playerMorph = (AbstractPlayerMorph)iMorph).getPlayerMorph() != null && (playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(playerMorph.getPlayerMorph())) != null) {
                event.setContent((Component)Component.m_237113_((String)playerinfo.m_105312_().getName()));
            }
        }
    }
}

