/*
 * Decompiled with CFR 0.152.
 */
package com.furiusmax.bjornlib.leveling;

import com.furiusmax.bjornlib.BjornLibImpl;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.npc.Villager;

public class EntityLevelBuilder {
    public static Builder create(LivingEntity entity, ServerLevel serverLevel) {
        return new Builder(entity, serverLevel);
    }

    public static class Builder {
        static final Random random = new Random();
        LivingEntity entity;
        ServerLevel serverLevel;
        int playerLevel;
        int maxPlayerLevel;
        int defaultDimensionLevel;
        int aboveLevelRange;
        int belowLevelRange;
        double healthFactor = 0.7;
        double damageFactor = 0.8;
        double damageMultiplier = 6.0;
        Map<ResourceLocation, Integer> dimensionLevels;
        executeExtraCode extras;

        protected Builder(LivingEntity entity, ServerLevel serverLevel) {
            this.entity = entity;
            this.serverLevel = serverLevel;
        }

        public Builder nearestPlayerLevel(int playerLevel) {
            this.playerLevel = playerLevel;
            return this;
        }

        public Builder maxPlayerLevel(int max) {
            this.maxPlayerLevel = max;
            return this;
        }

        public Builder setDefaulDimensionLevel(int level) {
            this.defaultDimensionLevel = level;
            return this;
        }

        public Builder setLevelRange(int above, int below) {
            this.aboveLevelRange = above;
            this.belowLevelRange = below;
            return this;
        }

        public Builder setLevelRange(int range) {
            this.aboveLevelRange = range;
            this.belowLevelRange = range;
            return this;
        }

        public Builder executeExtraCode(executeExtraCode extras) {
            this.extras = extras;
            return this;
        }

        public Builder setDimensionsCap(Map<ResourceLocation, Integer> map) {
            this.dimensionLevels = map;
            return this;
        }

        public Builder setHealthScaleFactor(double factor) {
            this.healthFactor = factor;
            return this;
        }

        public Builder setDamageScaleFactor(double factor) {
            this.damageFactor = factor;
            return this;
        }

        public Builder setDamageMultiplier(float multiply) {
            this.damageMultiplier = multiply;
            return this;
        }

        public Builder changeAttributes() {
            int mobLevel = Math.max(1, random.nextInt(this.playerLevel - this.belowLevelRange, this.playerLevel + this.aboveLevelRange + 1));
            if (this.extras != null) {
                this.extras.executeExtraCode();
            }
            for (Map.Entry<ResourceLocation, Integer> entry : this.dimensionLevels.entrySet()) {
                if (this.serverLevel.m_46472_().m_135782_().equals((Object)entry.getKey()) && mobLevel < entry.getValue()) {
                    mobLevel = entry.getValue();
                }
                if (this.dimensionLevels.containsKey(this.serverLevel.m_46472_().m_135782_()) || mobLevel >= this.defaultDimensionLevel) continue;
                mobLevel = this.defaultDimensionLevel;
            }
            if (mobLevel > this.maxPlayerLevel) {
                mobLevel = this.maxPlayerLevel;
            }
            if (!(this.entity instanceof EnderDragon) && this.entity instanceof LivingEntity) {
                if (this.entity.m_21204_().m_22171_(Attributes.f_22276_)) {
                    double mobHealth = (double)mobLevel * (this.entity.m_21051_(Attributes.f_22276_).m_22135_() * this.healthFactor);
                    this.entity.m_21051_(Attributes.f_22276_).m_22100_(mobHealth);
                    this.entity.m_5634_(this.entity.m_21233_());
                }
                if (this.entity.m_21204_().m_22171_(Attributes.f_22281_)) {
                    double mobDamage = (double)mobLevel * (this.entity.m_21051_(Attributes.f_22281_).m_22135_() * this.damageFactor) * this.damageMultiplier;
                    this.entity.m_21051_(Attributes.f_22281_).m_22100_(mobDamage);
                }
            }
            if (this.entity.m_7770_() == null) {
                if (BuiltInRegistries.f_256780_.m_7981_((Object)this.entity.m_6095_()).m_135827_().equals("mca")) {
                    this.entity.m_6593_((Component)Component.m_237113_((String)(Component.m_237115_((String)this.entity.m_6095_().m_20675_()).getString() + " Level : " + mobLevel)));
                } else if (this.entity instanceof Villager) {
                    this.entity.m_6593_((Component)Component.m_237113_((String)(this.entity.m_7755_().getString() + " Level : " + mobLevel)));
                } else {
                    this.entity.m_6593_((Component)Component.m_237113_((String)(Component.m_237115_((String)this.entity.m_6095_().m_20675_()).getString() + " Level : " + mobLevel)));
                }
            } else {
                this.entity.m_6593_((Component)Component.m_237113_((String)(this.entity.m_7770_().getString() + " Level : " + mobLevel)));
            }
            BjornLibImpl.INSTANCE.setEntityLevel((Entity)this.entity, mobLevel);
            return this;
        }
    }

    public static interface executeExtraCode {
        public void executeExtraCode();
    }
}

