/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy.client.render;

import codyhuh.breezy.client.render.BalloonDyeLayer;
import codyhuh.breezy.common.entity.HotAirBalloonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HotAirBalloonRenderer
extends GeoEntityRenderer<HotAirBalloonEntity> {
    public HotAirBalloonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DefaultedEntityGeoModel(new ResourceLocation("breezy", "hot_air_balloon")));
        this.addRenderLayer(new BalloonDyeLayer((GeoRenderer<HotAirBalloonEntity>)this));
    }

    public RenderType getRenderType(HotAirBalloonEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return super.getRenderType((GeoAnimatable)animatable, texture, bufferSource, partialTick);
    }

    public void render(HotAirBalloonEntity animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        float f = (float)animatable.getHurtTime() - partialTick;
        float f1 = animatable.getDamage() - partialTick;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f1 / 10.0f * (float)animatable.getHurtDirection()));
        }
        super.m_7392_((Entity)animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void preRender(PoseStack poseStack, HotAirBalloonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Optional arm;
        int i;
        for (i = 1; i <= 8; ++i) {
            arm = model.getBone("sandBag" + i);
            arm.ifPresent(geoBone -> geoBone.setHidden(true));
        }
        for (i = 1; i <= animatable.getSandbags(); ++i) {
            arm = model.getBone("sandBag" + i);
            arm.ifPresent(geoBone -> geoBone.setHidden(false));
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public boolean shouldShowName(@NotNull HotAirBalloonEntity p_114504_) {
        return false;
    }
}

