/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy.common.network;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class NewWindSavedData
extends SavedData {
    private static final int LAYERS = 12;
    private static final double[] windDirections = new double[12];

    public NewWindSavedData(long seed) {
        Random random = new Random(seed);
        NewWindSavedData.windDirections[0] = random.nextDouble() * 360.0;
        for (int i = 1; i < 12; ++i) {
            double prevDir = windDirections[i - 1];
            double minDelta = 60.0;
            double maxDelta = 120.0;
            double dirDelta = minDelta + (maxDelta - minDelta) * random.nextDouble();
            NewWindSavedData.windDirections[i] = random.nextBoolean() ? (prevDir + dirDelta) % 360.0 : (prevDir - dirDelta + 360.0) % 360.0;
        }
    }

    public NewWindSavedData(CompoundTag tag) {
        ListTag listTag = tag.m_128437_("Directions", 6);
        for (int i = 0; i < listTag.size(); ++i) {
            NewWindSavedData.windDirections[i] = listTag.m_128772_(i);
        }
    }

    public static void resetWindDirections(int timePassed, double percentage) {
        Random random = new Random(timePassed);
        double maxChange = 360.0 * percentage;
        for (int i = 0; i < 12; ++i) {
            double change = (random.nextDouble() * 2.0 - 1.0) * maxChange;
            NewWindSavedData.windDirections[i] = (windDirections[i] + change + 360.0) % 360.0;
        }
    }

    public double getWindAtHeight(int height, Level level) {
        return windDirections[this.normalize(height, level)];
    }

    public int getLayer(int yValue, Level level) {
        return this.normalize(yValue, level);
    }

    public double[] getWindDirections() {
        return windDirections;
    }

    private int normalize(int height, Level level) {
        int minBuildHeight = level.m_141937_() - 32;
        int maxBuildHeight = level.m_151558_() + 32;
        if (height > maxBuildHeight || height < minBuildHeight) {
            return 0;
        }
        return (height - minBuildHeight) * 12 / (maxBuildHeight - minBuildHeight);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag directionsTag = new ListTag();
        tag.m_128365_("Directions", (Tag)directionsTag);
        for (double dir : windDirections) {
            directionsTag.add((Object)DoubleTag.m_128500_((double)dir));
        }
        return tag;
    }
}

