/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="breezy", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BreezyConfig {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Integer> windPeriodLength;
        public final ForgeConfigSpec.ConfigValue<Boolean> windChanges;
        public final ForgeConfigSpec.ConfigValue<Double> changePercentage;
        public final ForgeConfigSpec.ConfigValue<Double> lowWindBiomeSpeedPenalty;
        public final ForgeConfigSpec.ConfigValue<Double> highWindBiomeSpeedBonus;
        public final ForgeConfigSpec.ConfigValue<Double> altitudeMultiplier;
        public final ForgeConfigSpec.ConfigValue<Boolean> furnaceFuel;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            builder.push("wind patterns");
            this.windPeriodLength = builder.comment("Duration in ticks for how often the wind changes\nDefault: 24000").define("wind_period_length", (Object)24000);
            this.windChanges = builder.comment("Whether wind changes at all").define("wind_changes", true);
            this.changePercentage = builder.comment("Percent by which wind changes each duration\nDefault: 2.5%").defineInRange("wind_change_percent", 0.025, 0.0, 1.0);
            builder.push("speed modifiers");
            this.lowWindBiomeSpeedPenalty = builder.comment("Speed modifier for biomes with less wind\nDefault: 0.7").define("low_wind_modifier", (Object)0.7);
            this.highWindBiomeSpeedBonus = builder.comment("Speed modifier for biomes with more wind\nDefault: 1.3").define("high_wind_modifier", (Object)1.3);
            this.altitudeMultiplier = builder.comment("Speed modifier added for each higher atmospheric layer\nDefault: 0.065").define("altitude_bonus", (Object)0.065);
            builder.pop();
            builder.pop();
            this.furnaceFuel = builder.comment("Whether hot air balloons take in furnace fuel instead of ignition").define("furnace_fuel", false);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldDisplayWind;
        public final ForgeConfigSpec.ConfigValue<Integer> minimumWindHeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> windMustSeeSky;
        public final ForgeConfigSpec.ConfigValue<Double> lowWindFrequency;
        public final ForgeConfigSpec.ConfigValue<Double> defaultWindFrequency;
        public final ForgeConfigSpec.ConfigValue<Double> highWindFrequency;
        public final ForgeConfigSpec.ConfigValue<Boolean> balloonsAlwaysRender;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            builder.push("particles");
            this.shouldDisplayWind = builder.comment("Should wind be displayed?\nDefault: true").define("should_display_wind", true);
            this.minimumWindHeight = builder.comment("How high above sea level should wind be displayed?\nDefault: 20").define("minimum_wind_height_above_sea_level", (Object)20);
            this.windMustSeeSky = builder.comment("Wind particles may only spawn in blocks with access to sky\nDefault: true").define("wind_must_see_sky", true);
            builder.push("biome dependent frequency multipliers");
            this.lowWindFrequency = builder.comment("Wind freq multiplier for low_wind biomes\nDefault: 0.005").defineInRange("low_wind_frequency", 0.005, 0.0, 1.0);
            this.defaultWindFrequency = builder.comment("Wind freq multiplier by default\nDefault: 0.01").defineInRange("medium_wind_frequency", 0.01, 0.0, 1.0);
            this.highWindFrequency = builder.comment("Wind freq multiplier for high_wind biomes\nDefault: 0.015").defineInRange("high_wind_frequency", 0.015, 0.0, 1.0);
            builder.pop();
            builder.pop();
            this.balloonsAlwaysRender = builder.comment("Should balloons render from farther distances?\nDefault: true").define("balloons_render_farther_away", true);
            builder.pop();
        }
    }
}

