/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.breezy.common.entity;

import codyhuh.breezy.BreezyConfig;
import codyhuh.breezy.common.network.BreezyNetworking;
import codyhuh.breezy.common.network.NewWindSavedData;
import codyhuh.breezy.core.other.tags.BreezyBiomeTags;
import codyhuh.breezy.core.other.tags.BreezyEntityTypeTags;
import codyhuh.breezy.core.other.tags.BreezyItemTags;
import codyhuh.breezy.core.other.util.WindMathUtil;
import codyhuh.breezy.core.registry.BreezyItems;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HotAirBalloonEntity
extends LivingEntity
implements GeoEntity {
    public static final AABB BASKET_AABB = new AABB(-0.7, 0.0, -0.7, 0.7, 1.0, 0.7);
    public static final AABB BALLOON_AABB = new AABB(-1.2, 2.4, -1.2, 1.2, 5.0, 1.2);
    public static final int MAX_LITNESS = 5;
    public static final int MAX_SANDBAGS = 8;
    public static final int DEFAULT_COLOR = 16351261;
    private static final EntityDataAccessor<Integer> LITNESS = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SANDBAGS = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(HotAirBalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HotAirBalloonEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LITNESS, (Object)0);
        this.f_19804_.m_135372_(SANDBAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)16351261);
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public boolean m_142066_() {
        return false;
    }

    public void setDamage(float p_38110_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_38110_));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_38155_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38155_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int p_38161_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_38161_);
    }

    public int getHurtDirection() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void m_6053_(float p_265265_) {
        this.setHurtDir(-this.getHurtDirection());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_38320_) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDirection());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_38320_ * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.destroy();
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public void destroy() {
        this.m_146870_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = new ItemStack((ItemLike)BreezyItems.HOT_AIR_BALLOON.get());
            if (this.getColor() != 16351261) {
                CompoundTag compoundtag = itemstack.m_41698_("display");
                compoundtag.m_128405_("color", this.getColor());
            }
            this.m_19983_(itemstack);
        }
    }

    public void m_8119_() {
        List list;
        Entity entity;
        super.m_8119_();
        if (this.f_19797_ % 10 == 0 && this.f_19796_.m_188499_() && !this.m_20197_().isEmpty() && (entity = this.m_146895_()) != null) {
            if (entity.m_6095_().m_204039_(BreezyEntityTypeTags.HOT_ONES) && this.getLitness() != 3) {
                this.setLitness(3);
            } else if (entity.m_6060_() && this.getLitness() < 2) {
                this.setLitness(this.getLitness() + 1);
            }
        }
        if (this.getLitness() > 0) {
            Level level;
            if (this.f_19797_ % (this.getLitness() * 80) == 0 && this.f_19796_.m_188499_()) {
                this.setLitness(this.getLitness() - 1);
            }
            if (this.f_19796_.m_188503_(8) == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                Vec3 origin = this.boxInLevel(BALLOON_AABB).m_82399_().m_82492_(0.0, 1.5, 0.0);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, origin.f_82479_, origin.f_82480_, origin.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.m_20070_()) {
            Level level;
            Holder holder = this.m_9236_().m_204166_(this.m_20183_());
            if (((Biome)holder.get()).m_198906_(this.m_20183_()) && this.m_9236_().m_45527_(this.m_20183_()) && !this.m_20096_() && this.m_9236_().m_46470_() && this.f_19796_.m_188503_(100) == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                if (lightningbolt != null) {
                    lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_().m_7494_()));
                    server.m_7967_((Entity)lightningbolt);
                }
            }
            if (this.f_19796_.m_188503_(20) == 0) {
                this.setLitness(this.getLitness() - 1);
            }
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (!(list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this))).isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity2 : list) {
                if (entity2.m_20363_((Entity)this)) continue;
                AABB validBasket = BASKET_AABB.m_82377_(-0.2, 0.72, -0.2);
                if (flag && this.m_20197_().isEmpty() && !entity2.m_20159_() && (double)entity2.m_20205_() < validBasket.m_82362_() && entity2 instanceof LivingEntity && !(entity2 instanceof WaterAnimal) && !(entity2 instanceof Player) && (double)entity2.m_20206_() < validBasket.m_82376_()) {
                    entity2.m_20329_((Entity)this);
                    continue;
                }
                if (!this.boxInLevel(BALLOON_AABB).m_82381_(entity2.m_20191_()) && !this.boxInLevel(BASKET_AABB).m_82381_(entity2.m_20191_())) continue;
                this.m_7334_(entity2);
            }
        }
    }

    private void peterPanParticles(ServerLevel level, AABB box) {
        if (level.f_46441_.m_188499_()) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            double x = box.f_82288_ + (box.f_82291_ - box.f_82288_) * this.f_19796_.m_188500_();
            double y = box.f_82289_ + (box.f_82292_ - box.f_82289_) * this.f_19796_.m_188500_();
            double z = box.f_82290_ + (box.f_82293_ - box.f_82290_) * this.f_19796_.m_188500_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_6138_() {
        this.theRealPush(this.boxInLevel(BALLOON_AABB));
        this.theRealPush(this.boxInLevel(BASKET_AABB));
    }

    private void theRealPush(AABB box) {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), box, EntitySelector.m_20421_((Entity)this)).forEach(x$0 -> this.m_7324_((Entity)x$0));
        } else {
            List list = this.m_9236_().m_6249_((Entity)this, box, EntitySelector.m_20421_((Entity)this));
            if (!list.isEmpty()) {
                int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
                if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                    int j = 0;
                    for (Entity entity : list) {
                        if (entity.m_20159_()) continue;
                        ++j;
                    }
                    if (j > i - 1) {
                        this.m_6469_(this.m_269291_().m_269354_(), 6.0f);
                    }
                }
                for (Entity entity : list) {
                    this.m_7324_(entity);
                }
            }
        }
    }

    public void m_5997_(double x, double y, double z) {
        this.m_20256_(this.m_20184_().m_82520_(x * 0.8, y * 0.8, z * 0.8));
        this.f_19812_ = true;
    }

    protected float m_5632_(float p_21260_, float p_21261_) {
        return p_21261_;
    }

    public void m_7023_(@NotNull Vec3 lookVectorMaybe) {
        if (this.m_6084_()) {
            NewWindSavedData data = BreezyNetworking.CLIENT_CACHE;
            if (data != null) {
                Vec3 targetVel = this.getTargetDirection(data);
                Vec3 lerpedVel = WindMathUtil.vec3Lerp(this.m_20184_(), targetVel, 0.06f);
                this.m_20256_(lerpedVel);
            }
            super.m_7023_(lookVectorMaybe);
        }
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13131_);
    }

    public Vec3 getTargetDirection(NewWindSavedData data) {
        double direction = data.getWindAtHeight(this.m_20183_().m_123342_(), this.m_9236_());
        Holder holder = this.m_9236_().m_204166_(this.m_20183_());
        int litness = this.getLitness();
        Vec3 wind = new Vec3(WindMathUtil.stepX(direction), 0.0, WindMathUtil.stepZ(direction)).m_82490_((double)0.2f);
        double uplift = 0.0;
        if (litness > 0) {
            uplift += (double)(litness + 1) * 0.03;
            if (this.m_20096_()) {
                this.m_6853_(false);
            }
        }
        if (this.f_146808_ || this.m_20072_()) {
            return new Vec3(0.0, -0.075, 0.0);
        }
        if (litness == 0) {
            wind = wind.m_82490_(0.5);
            if (this.m_20096_()) {
                return new Vec3(0.0, -0.075, 0.0);
            }
            uplift -= 0.075;
        }
        if (!this.m_9236_().m_45527_(this.m_20183_())) {
            wind = wind.m_82490_(0.5);
        }
        if (this.getSandbags() > 0) {
            uplift -= (double)(this.getSandbags() + 1) * 0.025;
        }
        if (this.m_20186_() >= (double)(this.m_9236_().m_151558_() - 24)) {
            uplift = -0.0075;
        }
        double biomePenalty = (Double)BreezyConfig.COMMON.lowWindBiomeSpeedPenalty.get();
        double biomeBonus = (Double)BreezyConfig.COMMON.highWindBiomeSpeedBonus.get();
        wind = wind.m_82520_(0.0, uplift, 0.0);
        if (holder.m_203656_(BreezyBiomeTags.NO_WIND)) {
            return new Vec3(0.0, uplift, 0.0);
        }
        if (holder.m_203656_(BreezyBiomeTags.LESS_WIND)) {
            wind = wind.m_82490_(biomePenalty);
        } else if (holder.m_203656_(BreezyBiomeTags.MORE_WIND)) {
            wind = wind.m_82490_(biomeBonus);
        }
        double altitudeBonus = (double)data.getLayer(this.m_20183_().m_123342_(), this.m_9236_()) * (Double)BreezyConfig.COMMON.altitudeMultiplier.get();
        wind = wind.m_82542_(1.0 + altitudeBonus, 1.0, 1.0 + altitudeBonus);
        return wind;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean moveInFluid(FluidState state, Vec3 movementVector, double gravity) {
        return false;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        return this.interactionBusiness(player, hand, this.isLookingAtHitbox(player, this.boxInLevel(BASKET_AABB)), this.isLookingAtHitbox(player, this.boxInLevel(BALLOON_AABB)));
    }

    boolean isLookingAtHitbox(Player player, AABB box) {
        Vec3 playerEyePosition = player.m_20299_(1.0f);
        Vec3 playerViewVector = player.m_20252_(1.0f).m_82541_();
        Vec3 lookTarget = playerEyePosition.m_82549_(playerViewVector.m_82490_(player.getEntityReach()));
        Optional intersection = box.m_82371_(playerEyePosition, lookTarget);
        return intersection.isPresent();
    }

    public AABB boxInLevel(AABB box) {
        return new AABB(box.f_82288_ + this.m_20185_(), box.f_82289_ + this.m_20186_(), box.f_82290_ + this.m_20189_(), box.f_82291_ + this.m_20185_(), box.f_82292_ + this.m_20186_(), box.f_82293_ + this.m_20189_());
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        return this.m_7111_(player, Vec3.f_82478_, hand);
    }

    public InteractionResult interactionBusiness(Player player, InteractionHand hand, boolean basket, boolean balloon) {
        if (!(basket || balloon || this.m_20197_().isEmpty() || this.m_20363_((Entity)player))) {
            Entity rider = (Entity)this.m_20197_().get(0);
            return player.m_36157_(rider, hand);
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (balloon) {
            DyeItem dye;
            int dyecolor;
            Item item;
            if (this.getLitness() < 5) {
                boolean lit = false;
                if (((Boolean)BreezyConfig.COMMON.furnaceFuel.get()).booleanValue()) {
                    int fuelTime;
                    if (itemstack.m_204117_(BreezyItemTags.FUEL) && (fuelTime = ForgeHooks.getBurnTime((ItemStack)itemstack, (RecipeType)RecipeType.f_44108_)) > 0) {
                        this.setLitness(this.getLitness() + Math.min(fuelTime / 20 / 40, 5));
                        lit = true;
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                            if (itemstack.hasCraftingRemainingItem()) {
                                ItemStack container = itemstack.getCraftingRemainingItem();
                                if (itemstack.m_41619_()) {
                                    itemstack = container;
                                } else {
                                    player.m_36176_(container, false);
                                }
                            }
                        }
                    }
                } else if (itemstack.m_204117_(BreezyItemTags.IGNITION_SOURCES)) {
                    this.setLitness(this.getLitness() + 2);
                    itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                    lit = true;
                }
                if (lit) {
                    this.m_5496_(SoundEvents.f_11942_, 1.0f, 1.0f);
                    Vec3 origin = this.boxInLevel(BALLOON_AABB).m_82399_().m_82492_(0.0, 1.85, 0.0);
                    for (int i = 0; i < 5; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, origin.f_82479_, origin.f_82480_, origin.f_82481_, 0.0, 0.0, 0.0);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if ((item = itemstack.m_41720_()) instanceof DyeItem && (dyecolor = (dye = (DyeItem)item).m_41089_().m_41070_()) != this.getColor()) {
                this.dyeBalloon(dye);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (basket) {
            if (player.m_21120_(hand).m_204117_(ItemTags.f_13137_)) {
                if (this.getSandbags() < 8) {
                    this.setSandbags(this.getSandbags() + 1);
                    this.m_5496_(SoundEvents.f_12334_, 1.0f, 1.5f);
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (this.getSandbags() > 0 && player.m_21120_(hand).m_204117_(Tags.Items.SHEARS)) {
                this.setSandbags(this.getSandbags() - 1);
                this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                return InteractionResult.SUCCESS;
            }
            if (this.m_20197_().isEmpty()) {
                if (!this.m_9236_().f_46443_) {
                    return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void dyeBalloon(DyeItem dye) {
        int[] aint = new int[3];
        int i = 0;
        int j = 2;
        int k = this.getColor();
        float f = (float)(k >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(k & 0xFF) / 255.0f;
        i += (int)(Math.max(f, Math.max(f1, f2)) * 255.0f);
        aint[0] = aint[0] + (int)(f * 255.0f);
        aint[1] = aint[1] + (int)(f1 * 255.0f);
        aint[2] = aint[2] + (int)(f2 * 255.0f);
        float[] afloat = dye.m_41089_().m_41068_();
        int i2 = (int)(afloat[0] * 255.0f);
        int l = (int)(afloat[1] * 255.0f);
        int i1 = (int)(afloat[2] * 255.0f);
        i += Math.max(i2, Math.max(l, i1));
        aint[0] = aint[0] + i2;
        aint[1] = aint[1] + l;
        aint[2] = aint[2] + i1;
        int j1 = aint[0] / j;
        int k1 = aint[1] / j;
        int l1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        this.setColor(j2);
    }

    public LivingEntity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (LivingEntity)this.m_20197_().get(0);
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 p_30562_, LivingEntity p_30563_) {
        double d0 = this.m_20185_() + p_30562_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_30562_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_30563_.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ - 3.5;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB aabb = p_30563_.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)p_30563_, (AABB)aabb.m_82383_(vec3))) {
                        p_30563_.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity living) {
        Vec3 vec3 = HotAirBalloonEntity.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.m_146908_() + (living.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, living);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = HotAirBalloonEntity.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.m_146908_() + (living.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, living);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean m_7337_(@NotNull Entity p_38376_) {
        return HotAirBalloonEntity.canVehicleCollide((Entity)this, p_38376_);
    }

    public static boolean canVehicleCollide(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    public boolean m_6094_() {
        return this.m_20197_().isEmpty();
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public boolean isPushedByFluid(FluidType type) {
        return true;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CustomColor", this.getColor());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("CustomColor", 99)) {
            this.setColor(tag.m_128451_("CustomColor"));
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setColor(int p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_);
    }

    public void setLitness(int litness) {
        this.f_19804_.m_135381_(LITNESS, (Object)Math.max(0, litness));
    }

    public int getLitness() {
        return Math.min((Integer)this.f_19804_.m_135370_(LITNESS), 5);
    }

    public void setSandbags(int sandbags) {
        this.f_19804_.m_135381_(SANDBAGS, (Object)sandbags);
    }

    public int getSandbags() {
        return Math.min((Integer)this.f_19804_.m_135370_(SANDBAGS), 8);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot p_21127_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot p_21036_, @NotNull ItemStack p_21037_) {
    }

    public double m_6048_() {
        if (!this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof Skeleton) {
            return 0.65;
        }
        return 0.5;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_6783_(double p_33107_) {
        return (Boolean)BreezyConfig.CLIENT.balloonsAlwaysRender.get() != false || super.m_6783_(p_33107_);
    }

    public boolean m_147207_(@NotNull MobEffectInstance p_182397_, @javax.annotation.Nullable Entity p_182398_) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82377_(0.2, 0.2, 0.2);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)BreezyItems.HOT_AIR_BALLOON.get());
    }

    public boolean m_7998_(@NotNull Entity p_19966_, boolean p_19967_) {
        return false;
    }

    public boolean m_6052_() {
        return false;
    }

    public boolean m_20152_() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

