/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class JamJarsBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.25, (double)5.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_NORTH_STACK = Block.m_49796_((double)3.5, (double)0.0, (double)11.0, (double)12.5, (double)10.5, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH_STACK = Block.m_49796_((double)3.5, (double)0.0, (double)1.0, (double)12.5, (double)10.5, (double)5.0);
    private static final VoxelShape SHAPE_EAST_STACK = Block.m_49796_((double)1.0, (double)0.0, (double)3.5, (double)5.0, (double)10.5, (double)12.5);
    private static final VoxelShape SHAPE_WEST_STACK = Block.m_49796_((double)11.0, (double)0.0, (double)3.5, (double)15.0, (double)10.5, (double)12.5);
    public static final BooleanProperty STACKED = BooleanProperty.m_61465_((String)"stacked");

    public JamJarsBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_21120_(pHand).m_41619_()) {
            if (!pLevel.f_46443_) {
                boolean stacked = (Boolean)pState.m_61143_((Property)STACKED);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)STACKED, (Comparable)Boolean.valueOf(!stacked)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        boolean stacked = (Boolean)pState.m_61143_((Property)STACKED);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (stacked) {
                    yield SHAPE_SOUTH_STACK;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (stacked) {
                    yield SHAPE_EAST_STACK;
                }
                yield SHAPE_EAST;
            }
            case Direction.WEST -> {
                if (stacked) {
                    yield SHAPE_WEST_STACK;
                }
                yield SHAPE_WEST;
            }
            default -> stacked ? SHAPE_NORTH_STACK : SHAPE_NORTH;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{STACKED});
    }
}

