/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.CardboardBoxState;
import net.redchujelly.cluttered.block.custom.furniture.storage.StorageBlock;
import net.redchujelly.cluttered.block.entity.CardboardBoxBlockEntity;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlock
extends StorageBlock {
    private static final VoxelShape SHAPE_CLOSED_NS = Block.m_49796_((double)4.0, (double)0.0, (double)2.5, (double)12.0, (double)7.0, (double)13.5);
    private static final VoxelShape SHAPE_CLOSED_EW = Block.m_49796_((double)2.5, (double)0.0, (double)4.0, (double)13.5, (double)7.0, (double)12.0);
    private static final VoxelShape SHAPE_FULL_NS = Block.m_49796_((double)4.0, (double)0.0, (double)2.5, (double)12.0, (double)11.0, (double)13.5);
    private static final VoxelShape SHAPE_FULL_EW = Block.m_49796_((double)2.5, (double)0.0, (double)4.0, (double)13.5, (double)11.0, (double)12.0);
    public static final EnumProperty<CardboardBoxState> OPEN_STATE = EnumProperty.m_61587_((String)"open_state", CardboardBoxState.class);

    public CardboardBoxBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(OPEN_STATE, (Comparable)((Object)CardboardBoxState.EMPTY)));
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        if (((CardboardBoxState)((Object)pState.m_61143_(OPEN_STATE))).equals((Object)CardboardBoxState.FULL)) {
            return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_FULL_NS : SHAPE_FULL_EW;
        }
        return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_CLOSED_NS : SHAPE_CLOSED_EW;
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6047_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof CustomStorageBlockEntity) {
                pPlayer.m_5893_((MenuProvider)((CustomStorageBlockEntity)blockEntity));
                return InteractionResult.CONSUME;
            }
        } else {
            if (((CardboardBoxState)((Object)pState.m_61143_(OPEN_STATE))).equals((Object)CardboardBoxState.CLOSED)) {
                BlockEntity entity = pLevel.m_7702_(pPos);
                if (!(entity instanceof CardboardBoxBlockEntity)) {
                    pLevel.m_7471_(pPos, false);
                    return InteractionResult.CONSUME;
                }
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(OPEN_STATE, (Comparable)((Object)(((CardboardBoxBlockEntity)entity).containsItems() ? CardboardBoxState.FULL : CardboardBoxState.EMPTY))), 2);
            } else {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(OPEN_STATE, (Comparable)((Object)CardboardBoxState.CLOSED)), 2);
            }
            pLevel.m_247517_(null, pPos, SoundEvents.f_144083_, SoundSource.BLOCKS);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN_STATE});
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)TileEntityRegistration.CARDBOARD_BOX_BE.get()).m_155264_(blockPos, blockState);
    }

    public static void updateOpenState(BlockPos pos, Level level) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof CardboardBoxBlock) {
            level.m_7731_(pos, (BlockState)state.m_61124_(OPEN_STATE, (Comparable)((Object)CardboardBoxBlock.getOpenState(pos, level))), 2);
        }
    }

    private static CardboardBoxState getOpenState(BlockPos pos, Level level) {
        BlockState stateAtPos = level.m_8055_(pos);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CardboardBoxBlockEntity && stateAtPos.m_61138_(OPEN_STATE)) {
            if (((CardboardBoxState)((Object)stateAtPos.m_61143_(OPEN_STATE))).equals((Object)CardboardBoxState.CLOSED)) {
                return CardboardBoxState.CLOSED;
            }
            if (((CardboardBoxBlockEntity)entity).containsItems()) {
                return CardboardBoxState.FULL;
            }
        }
        return CardboardBoxState.EMPTY;
    }
}

