/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CustomStorageBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items;
    private final int size;
    private final ContainerOpenersCounter openersCounter;

    public CustomStorageBlockEntity(BlockEntityType<?> pType, final BlockPos pPos, BlockState pBlockState, int rows) {
        super(pType, pPos, pBlockState);
        this.size = rows * 9;
        this.items = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
                level.m_247517_(null, pPos, SoundEvents.f_11725_, SoundSource.BLOCKS);
            }

            protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
                level.m_247517_(null, pPos, SoundEvents.f_11724_, SoundSource.BLOCKS);
            }

            protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            }

            protected boolean m_142718_(Player player) {
                return false;
            }
        };
    }

    public CustomStorageBlockEntity(BlockEntityType<?> pType, final BlockPos pPos, BlockState pBlockState, int rows, final SoundEvent openSound, final SoundEvent closeSound) {
        super(pType, pPos, pBlockState);
        this.size = rows * 9;
        this.items = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
                level.m_247517_(null, pPos, openSound, SoundSource.BLOCKS);
            }

            protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
                level.m_247517_(null, pPos, closeSound, SoundSource.BLOCKS);
            }

            protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            }

            protected boolean m_142718_(Player player) {
                return false;
            }
        };
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        }
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"cluttered.storage");
    }

    protected AbstractContainerMenu m_6555_(int pId, Inventory pInventory) {
        return switch (this.size / 9) {
            case 1 -> new ChestMenu(MenuType.f_39957_, pId, pInventory, (Container)this, this.size / 9);
            case 2 -> new ChestMenu(MenuType.f_39958_, pId, pInventory, (Container)this, this.size / 9);
            case 4 -> new ChestMenu(MenuType.f_39960_, pId, pInventory, (Container)this, this.size / 9);
            case 5 -> new ChestMenu(MenuType.f_39961_, pId, pInventory, (Container)this, this.size / 9);
            case 6 -> ChestMenu.m_39246_((int)pId, (Inventory)pInventory, (Container)this);
            default -> ChestMenu.m_39237_((int)pId, (Inventory)pInventory, (Container)this);
        };
    }

    public int m_6643_() {
        return this.size;
    }
}

