/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import net.redchujelly.cluttered.entity.ChairEntity;
import net.redchujelly.cluttered.setup.EntityTypeRegistration;

public class MultiblockChair
extends MultiblockPlacer {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    private static final float SEAT_OFFSET = 0.5f;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}};

    public MultiblockChair(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!((Boolean)pState.m_61143_((Property)OCCUPIED)).booleanValue() && !pPlayer.m_6144_()) {
            if (!pLevel.f_46443_) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 2);
                ChairEntity seat = new ChairEntity((EntityType)EntityTypeRegistration.CHAIR_ENTITY.get(), pLevel, pPos);
                seat.m_6034_((double)pPos.m_123341_() + 0.5, (float)(pPos.m_123342_() - 1) + this.getSeatOffset(), (double)pPos.m_123343_() + 0.5);
                pLevel.m_7967_((Entity)seat);
                pPlayer.m_20329_((Entity)seat);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        List chairBlocks = pLevel.m_45976_(ChairEntity.class, new AABB(pPos));
        for (ChairEntity chair : chairBlocks) {
            chair.m_6074_();
        }
    }

    public float getSeatOffset() {
        return 0.5f;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OCCUPIED});
    }
}

