/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.PicketFenceGateBlock;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import org.jetbrains.annotations.Nullable;

public class WeddingArchBlock
extends MultiblockPlacer {
    private static final VoxelShape SUPPORT_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SHAPE_1367 = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_N_1367 = Block.m_49796_((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_S_1367 = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_E_1367 = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_W_1367 = Block.m_49796_((double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_N_35 = Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_S_35 = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_E_35 = Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_35 = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_NS_4 = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_EW_4 = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.m_61631_((String)"part", (int)1, (int)7);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {0}, {7}}, new int[][]{{2}, {0}, {6}}, new int[][]{{3}, {4}, {5}}};

    public WeddingArchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SUPPORT_SHAPE;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape1;
        int part = (Integer)pState.m_61143_((Property)MULTIBLOCK_PART);
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if (part == 1 || part == 2 || part == 6 || part == 7) {
            shape1 = SHAPE_1367;
        } else if (part == 4) {
            shape1 = facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_NS_4 : SHAPE_EW_4;
        } else {
            switch (facing) {
                case SOUTH: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_S_35;
                        break;
                    }
                    voxelShape = SHAPE_N_35;
                    break;
                }
                case EAST: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_E_35;
                        break;
                    }
                    voxelShape = SHAPE_W_35;
                    break;
                }
                case WEST: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_W_35;
                        break;
                    }
                    voxelShape = SHAPE_E_35;
                    break;
                }
                default: {
                    VoxelShape voxelShape = shape1 = part == 3 ? SHAPE_N_35 : SHAPE_S_35;
                }
            }
        }
        if (((Boolean)pState.m_61143_((Property)SOUTH)).booleanValue()) {
            shape1 = Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)SHAPE_N_1367);
        }
        if (((Boolean)pState.m_61143_((Property)NORTH)).booleanValue()) {
            shape1 = Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)SHAPE_S_1367);
        }
        if (((Boolean)pState.m_61143_((Property)WEST)).booleanValue()) {
            shape1 = Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)SHAPE_E_1367);
        }
        if (((Boolean)pState.m_61143_((Property)EAST)).booleanValue()) {
            shape1 = Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)SHAPE_W_1367);
        }
        return shape1;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos OGpos = pContext.m_8083_();
        Direction direction = pContext.m_8125_();
        int[][][] multiblockShape = this.getMultiblockShape();
        int maxHeight = this.getMultiblockShape().length;
        int OGx = OGpos.m_123341_();
        int OGy = OGpos.m_123342_();
        int OGz = OGpos.m_123343_();
        int xOffset = 0;
        int zOffset = 0;
        if (OGpos.m_123342_() + maxHeight >= level.m_151558_()) {
            return null;
        }
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] == 0 || level.m_8055_(new BlockPos(OGx + (xOffset = this.getXOffset(direction, x, z)), OGy + y, OGz + (zOffset = this.getZOffset(direction, x, z)))).m_247087_()) continue;
                    return null;
                }
            }
        }
        Level $$1 = pContext.m_43725_();
        BlockPos $$2 = pContext.m_8083_();
        BlockPos $$4 = $$2.m_122012_();
        BlockPos $$5 = $$2.m_122029_();
        BlockPos $$6 = $$2.m_122019_();
        BlockPos $$7 = $$2.m_122024_();
        BlockState $$8 = $$1.m_8055_($$4);
        BlockState $$9 = $$1.m_8055_($$5);
        BlockState $$10 = $$1.m_8055_($$6);
        BlockState $$11 = $$1.m_8055_($$7);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo($$8)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo($$9)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo($$10)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo($$11)));
    }

    @Override
    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            int[][][] multiblockShape = this.getMultiblockShape();
            int OGx = pPos.m_123341_();
            int OGy = pPos.m_123342_();
            int OGz = pPos.m_123343_();
            if ((Integer)pState.m_61143_((Property)this.getMultiblockPart()) == 1 && !pOldState.m_60713_(this.m_7374_())) {
                for (int y = 0; y < multiblockShape.length; ++y) {
                    for (int x = 0; x < multiblockShape[y].length; ++x) {
                        for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                            if (x + y + z == 0 || multiblockShape[y][x][z] == 0) continue;
                            int xOffset = this.getXOffset(direction, x, z);
                            int zOffset = this.getZOffset(direction, x, z);
                            Level $$1 = pLevel;
                            BlockPos $$2 = new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset);
                            BlockPos $$4 = $$2.m_122012_();
                            BlockPos $$5 = $$2.m_122029_();
                            BlockPos $$6 = $$2.m_122019_();
                            BlockPos $$7 = $$2.m_122024_();
                            BlockState $$8 = $$1.m_8055_($$4);
                            BlockState $$9 = $$1.m_8055_($$5);
                            BlockState $$10 = $$1.m_8055_($$6);
                            BlockState $$11 = $$1.m_8055_($$7);
                            pLevel.m_7731_($$2, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(multiblockShape[y][x][z]))).m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo($$8)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo($$9)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo($$10)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo($$11))), 2);
                        }
                    }
                }
            }
        }
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection.equals((Object)Direction.NORTH)) {
            pLevel.m_7731_(pCurrentPos, (BlockState)pState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.SOUTH)) {
            pLevel.m_7731_(pCurrentPos, (BlockState)pState.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.EAST)) {
            pLevel.m_7731_(pCurrentPos, (BlockState)pState.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.WEST)) {
            pLevel.m_7731_(pCurrentPos, (BlockState)pState.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private boolean connectsTo(BlockState pState) {
        boolean neighborFence;
        if (pState.m_60734_() instanceof WeddingArchBlock) {
            return false;
        }
        boolean bl = neighborFence = pState.m_204336_(BlockTags.f_13098_) || pState.m_204336_(BlockTags.f_13039_) || pState.m_204336_(BlockTags.f_13032_);
        if (!neighborFence && (pState.m_60734_() instanceof FenceGateBlock || pState.m_60734_() instanceof PicketFenceGateBlock)) {
            neighborFence = ((Direction)pState.m_61143_((Property)FACING)).equals((Object)pState.m_61143_((Property)FACING)) || ((Direction)pState.m_61143_((Property)FACING)).equals((Object)((Direction)pState.m_61143_((Property)FACING)).m_122424_());
        }
        return neighborFence;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{WEST});
    }
}

