/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.worldgen.tree.custom.BlueMushroomFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.CrabappleFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.CrabappleTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.MapleFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.MapleTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.PoplarFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.RedMushroomFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.RedMushroomTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.SycamoreFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.SycamoreTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowTreeDecorator;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowTrunkPlacer;

public class ClutteredConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW_KEY = ClutteredConfiguredFeatures.registerKey("willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POPLAR_KEY = ClutteredConfiguredFeatures.registerKey("poplar");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_MUSHROOM_KEY = ClutteredConfiguredFeatures.registerKey("blue_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MUSHROOM_KEY = ClutteredConfiguredFeatures.registerKey("red_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRABAPPLE_KEY = ClutteredConfiguredFeatures.registerKey("crabapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SYCAMORE_KEY = ClutteredConfiguredFeatures.registerKey("sycamore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_KEY = ClutteredConfiguredFeatures.registerKey("fluorescent_maple");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ClutteredConfiguredFeatures.register(context, WILLOW_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.WILLOW_LOG.get()).m_49966_(), 1).m_146271_((Object)((Block)BlockRegistration.FLOWERING_WILLOW_LOG.get()).m_49966_(), 1).m_146270_()), (TrunkPlacer)new WillowTrunkPlacer(6, 2, 6), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.WILLOW_LEAVES.get()).m_49966_(), 3).m_146271_((Object)((Block)BlockRegistration.FLOWERING_WILLOW_LEAVES.get()).m_49966_(), 2).m_146270_()), (FoliagePlacer)new WillowFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)1), (IntProvider)ConstantInt.m_146483_((int)1), 1, 5), (FeatureSize)new TwoLayersFeatureSize(5, 2, 4)).m_68249_(List.of(new WillowTreeDecorator(0.6f))).m_68251_());
        ClutteredConfiguredFeatures.register(context, POPLAR_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.POPLAR_LOG.get()).m_49966_(), 1).m_146271_((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LOG.get()).m_49966_(), 1).m_146270_()), (TrunkPlacer)new StraightTrunkPlacer(6, 1, 3), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.POPLAR_LEAVES.get()).m_49966_(), 3).m_146271_((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LEAVES.get()).m_49966_(), 2).m_146270_()), (FoliagePlacer)new PoplarFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)5), 8), (FeatureSize)new TwoLayersFeatureSize(3, 0, 2)).m_68251_());
        ClutteredConfiguredFeatures.register(context, BLUE_MUSHROOM_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.BLUE_MUSHROOM_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 1, 3), (BlockStateProvider)WeightedStateProvider.m_191382_((Block)((Block)BlockRegistration.BLUE_MUSHROOM_CAP.get())), (FoliagePlacer)new BlueMushroomFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)4), 3), (FeatureSize)new TwoLayersFeatureSize(5, 0, 4)).m_68251_());
        ClutteredConfiguredFeatures.register(context, RED_MUSHROOM_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.RED_MUSHROOM_LOG.get())), (TrunkPlacer)new RedMushroomTrunkPlacer(6, 0, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.RED_MUSHROOM_CAP.get())), (FoliagePlacer)new RedMushroomFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)4), 5), (FeatureSize)new TwoLayersFeatureSize(4, 1, 3)).m_68251_());
        ClutteredConfiguredFeatures.register(context, CRABAPPLE_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.CRABAPPLE_LOG.get()).m_49966_(), 1).m_146271_((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_LOG.get()).m_49966_(), 1).m_146270_()), (TrunkPlacer)new CrabappleTrunkPlacer(4, 0, 2), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.CRABAPPLE_LEAVES.get()).m_49966_(), 2).m_146271_((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_LEAVES.get()).m_49966_(), 5).m_146270_()), (FoliagePlacer)new CrabappleFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).m_68251_());
        ClutteredConfiguredFeatures.register(context, SYCAMORE_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.SYCAMORE_LOG.get())), (TrunkPlacer)new SycamoreTrunkPlacer(6, 0, 4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.SYCAMORE_LEAVES.get())), (FoliagePlacer)new SycamoreFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)4), 6), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).m_68251_());
        ClutteredConfiguredFeatures.register(context, MAPLE_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)BlockRegistration.MAPLE_LOG.get())), (TrunkPlacer)new MapleTrunkPlacer(6, 1, 3), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)BlockRegistration.MAPLE_LEAVES.get()).m_49966_(), 25).m_146271_((Object)((Block)BlockRegistration.MAPLE_LEAVES_FLOWERING.get()).m_49966_(), 5).m_146270_()), (FoliagePlacer)new MapleFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)5)), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).m_68251_());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("cluttered", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

