/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.redchujelly.cluttered.block.custom.WillowVinesBlock;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.TreeDecoratorTypeRegistration;

public class WillowTreeDecorator
extends TreeDecorator {
    public static final Codec<WillowTreeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WillowTreeDecorator::new, willowTreeDecoratorInstance -> Float.valueOf(willowTreeDecoratorInstance.probability)).codec();
    private final float probability;

    public WillowTreeDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TreeDecoratorTypeRegistration.WILLOW_TREE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.m_226067_();
        for (BlockPos leafPos : pContext.m_226069_()) {
            if (!pContext.m_226059_(leafPos.m_7495_()) || !(randomsource.m_188501_() < this.probability)) continue;
            int strandLength = randomsource.m_216339_(4, 8);
            if (randomsource.m_188499_()) {
                strandLength -= 4;
            }
            int i = 0;
            while (i < strandLength && pContext.m_226059_(leafPos.m_6625_(++i))) {
                pContext.m_226061_(leafPos.m_6625_(i), (BlockState)((BlockState)((Block)BlockRegistration.WILLOW_VINES.get()).m_49966_().m_61124_((Property)WillowVinesBlock.GRADIENT, (Comparable)Integer.valueOf(Math.min(i, 6)))).m_61124_((Property)WillowVinesBlock.BOTTOM, (Comparable)Boolean.valueOf(i == strandLength)));
            }
        }
    }
}

