/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class WillowFoliagePlacer
extends FoliagePlacer {
    public static final Codec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.create(willowFoliagePlacerInstance -> WillowFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)willowFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).and((App)Codec.intRange((int)0, (int)10).fieldOf("length").forGetter(fp -> fp.length)).apply((Applicative)willowFoliagePlacerInstance, WillowFoliagePlacer::new));
    private final int height;
    private final int length;

    public WillowFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height, int length) {
        super(pRadius, pOffset);
        this.height = height;
        this.length = length;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.WILLOW_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i, FoliagePlacer.FoliageAttachment foliageAttachment, int i1, int i2, int i3) {
        BlockPos base = foliageAttachment.m_161451_().m_7494_();
        this.m_225628_(pLevel, foliageSetter, randomSource, treeConfiguration, base, 1, 0, foliageAttachment.m_68590_());
        List<BlockPos> posList = List.of(base.m_122012_(), base.m_122012_().m_122024_(), base.m_122019_(), base.m_122019_().m_122024_(), base.m_122029_(), base.m_122012_().m_122029_(), base.m_122024_(), base.m_122019_().m_122029_());
        boolean longStrand = true;
        block0: for (BlockPos pos : posList) {
            int strandLength;
            if (longStrand) {
                strandLength = this.length + randomSource.m_216339_(-2, 1);
                longStrand = false;
            } else {
                strandLength = this.length + randomSource.m_216339_(-8, -4);
                longStrand = true;
            }
            for (int j = 0; j < strandLength; ++j) {
                if (j == 1) {
                    if (longStrand && (double)randomSource.m_188501_() > 0.2) {
                        WillowFoliagePlacer.m_272253_((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.m_7494_());
                    } else if (!longStrand && (double)randomSource.m_188501_() > 0.68) {
                        WillowFoliagePlacer.m_272253_((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.m_7494_());
                    }
                }
                if (pLevel.m_7433_(pos.m_6625_(j), (Predicate)BlockStatePredicate.m_61287_((Block)((Block)BlockRegistration.WILLOW_LOG.get())))) continue block0;
                WillowFoliagePlacer.m_272253_((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.m_6625_(j));
            }
        }
    }

    public int m_214116_(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource randomSource, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

