/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cmparallelpipes;

import com.kreidev.cmparallelpipes.PipeWrenchItem;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="cmparallelpipes", value={Dist.CLIENT})
public class ClientHandler {
    public static List<FluidPipeBlockEntity> renderedBlockEntities = new ArrayList<FluidPipeBlockEntity>();

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41720_() instanceof PipeWrenchItem || player.m_21206_().m_41720_() instanceof PipeWrenchItem) {
            FluidPipeBlockEntity fluidPipeBlockEntity;
            BlockHitResult hit;
            if (level.m_46467_() % 5L == 1L) {
                Vec3 playerPos = player.m_20182_();
                int n = 2;
                int chunkX = player.m_146902_().f_45578_;
                int chunkZ = player.m_146902_().f_45579_;
                HashMap blockEntities = new HashMap();
                for (int dx = -n; dx <= n; ++dx) {
                    for (int dz = -n; dz <= n; ++dz) {
                        LevelChunk chunk = level.m_6325_(chunkX + dx, chunkZ + dz);
                        blockEntities.putAll(chunk.m_62954_());
                    }
                }
                renderedBlockEntities = blockEntities.values().stream().filter(be -> be instanceof FluidPipeBlockEntity).filter(be -> Vec3.m_82512_((Vec3i)be.m_58899_()).m_82509_((Position)playerPos, 24.0)).map(FluidPipeBlockEntity.class::cast).filter(PipeWrenchItem::isLocked).collect(Collectors.toList());
            }
            for (BlockEntity blockEntity : renderedBlockEntities) {
                BlockPos pos = blockEntity.m_58899_();
                BlockState state = level.m_8055_(pos);
                VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
                if (shape.m_83281_()) continue;
                Outliner.getInstance().showAABB((Object)blockEntity, shape.m_83215_().m_82338_(pos)).colored(14532966).lineWidth(0.03125f);
            }
            HitResult pos = player.m_19907_(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()), 0.0f, false);
            if (pos instanceof BlockHitResult && (pos = level.m_7702_((hit = (BlockHitResult)pos).m_82425_())) instanceof FluidPipeBlockEntity && PipeWrenchItem.isLocked(fluidPipeBlockEntity = (FluidPipeBlockEntity)pos)) {
                if (player.m_6047_()) {
                    pos = hit.m_82425_();
                    VoxelShape shape = fluidPipeBlockEntity.m_58900_().m_60808_((BlockGetter)level, (BlockPos)pos);
                    Outliner.getInstance().showAABB((Object)fluidPipeBlockEntity, shape.m_83215_().m_82338_((BlockPos)pos)).colored(-41620).lineWidth(0.032258064f);
                } else {
                    Vec3 hitLoc;
                    pos = hit.m_82425_();
                    BlockState blockState = level.m_8055_((BlockPos)pos);
                    Direction segment = PipeWrenchItem.getSegment(blockState, (BlockPos)pos, hitLoc = hit.m_82450_());
                    if (segment != null) {
                        AABB box = PipeWrenchItem.SEGMENT_SHAPES.get(segment).m_83215_().m_82338_((BlockPos)pos);
                        Outliner.getInstance().showAABB((Object)(String.valueOf(pos.m_121945_(segment)) + "highlight"), box).colored(-41620).lineWidth(0.032258064f);
                    } else {
                        segment = hit.m_82434_();
                        AABB box = PipeWrenchItem.SEGMENT_SHAPES.get(segment).m_83215_().m_82338_((BlockPos)pos).m_82383_(new Vec3(segment.m_253071_().mul(0.016129032f)));
                        Outliner.getInstance().showAABB((Object)(String.valueOf(pos.m_121945_(hit.m_82434_())) + "highlight"), box).colored(10411635).lineWidth(0.032258064f);
                    }
                }
            }
        } else {
            renderedBlockEntities.clear();
        }
    }
}

