/*
 * Decompiled with CFR 0.152.
 */
package com.kreidev.cmparallelpipes;

import com.kreidev.cmparallelpipes.ClientHandler;
import com.kreidev.cmparallelpipes.PipeLockingBehaviour;
import com.kreidev.cmparallelpipes.PipeWrenchItemRenderer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.Map;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class PipeWrenchItem
extends Item {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Map<Direction, VoxelShape> SEGMENT_SHAPES = Map.of(Direction.NORTH, Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25), Direction.EAST, Shapes.m_83048_((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75), Direction.SOUTH, Shapes.m_83048_((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0), Direction.WEST, Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75), Direction.UP, Shapes.m_83048_((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), Direction.DOWN, Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75));

    public PipeWrenchItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new PipeWrenchItemRenderer()));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (blockEntity instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity pipeBlockEntity = (FluidPipeBlockEntity)blockEntity;
            Player player = context.m_43723_();
            if (player == null) {
                return InteractionResult.PASS;
            }
            if (player.m_6047_()) {
                PipeWrenchItem.setLocked(pipeBlockEntity, false);
                if (level.m_5776_()) {
                    ClientHandler.renderedBlockEntities.remove(pipeBlockEntity);
                } else {
                    Direction.Axis preferred = FluidPropagator.getStraightPipeAxis((BlockState)blockState);
                    Direction preferredDirection = preferred == null ? Direction.UP : Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)preferred);
                    BlockState updated = ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(blockState, preferredDirection, null, (BlockAndTintGetter)level, pos);
                    if (updated != blockState) {
                        level.m_46597_(pos, updated);
                    }
                }
            } else if (!PipeWrenchItem.isLocked(pipeBlockEntity)) {
                PipeWrenchItem.setLocked(pipeBlockEntity, true);
                if (level.m_5776_()) {
                    ClientHandler.renderedBlockEntities.add(pipeBlockEntity);
                }
            } else if (!level.m_5776_()) {
                Direction segment = PipeWrenchItem.getSegment(blockState, pos, context.m_43720_());
                if (segment != null) {
                    int endPoints = 0;
                    for (Direction d : Iterate.directions) {
                        if (!FluidPipeBlock.isOpenAt((BlockState)blockState, (Direction)d)) continue;
                        ++endPoints;
                    }
                    if (endPoints > 2) {
                        BlockState state = (BlockState)blockState.m_61124_((Property)PipeBlock.f_55154_.get(segment), (Comparable)Boolean.valueOf(false));
                        level.m_46597_(pos, state);
                    }
                } else {
                    segment = context.m_43719_();
                    level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)PipeBlock.f_55154_.get(segment), (Comparable)Boolean.valueOf(true)));
                }
            }
            PipeWrenchItem.playLockingSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static void setLocked(FluidPipeBlockEntity pipeEntity, boolean locked) {
        PipeLockingBehaviour lockingBehaviour = (PipeLockingBehaviour)pipeEntity.getBehaviour(PipeLockingBehaviour.TYPE);
        if (lockingBehaviour != null) {
            lockingBehaviour.setLocked(locked);
        }
    }

    public static boolean isLocked(FluidPipeBlockEntity pipeEntity) {
        PipeLockingBehaviour lockingBehaviour = (PipeLockingBehaviour)pipeEntity.getBehaviour(PipeLockingBehaviour.TYPE);
        if (lockingBehaviour != null) {
            return lockingBehaviour.isLocked();
        }
        return false;
    }

    public static Direction getSegment(BlockState state, BlockPos pos, Vec3 hitLocation) {
        for (Direction direction : DIRECTIONS) {
            if (!FluidPipeBlock.isOpenAt((BlockState)state, (Direction)direction) || !SEGMENT_SHAPES.get(direction).m_83215_().m_82400_(0.01).m_82338_(pos).m_82390_(hitLocation)) continue;
            return direction;
        }
        return null;
    }

    public static void playLockingSound(Level level, BlockPos pos) {
        BlockState newState = level.m_8055_(pos);
        SoundType soundType = newState.m_60827_();
        level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }
}

