/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.provider.ProviderUtils;
import net.blay09.mods.cookingforblockheads.api.IKitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.network.message.MovedToOvenMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KitchenMultiBlock
implements IKitchenMultiBlock {
    private static final List<Block> blockConnectors = new ArrayList<Block>();
    private final Set<BlockPos> checkedPos = Sets.newHashSet();
    private final List<IKitchenItemProvider> itemProviderList = Lists.newArrayList();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = Lists.newArrayList();

    private KitchenMultiBlock(Level level, BlockPos pos) {
        this.findNeighbourKitchenBlocks(level, pos, true);
    }

    public static KitchenMultiBlock buildFromLocation(Level level, BlockPos pos) {
        return new KitchenMultiBlock(level, pos);
    }

    private void findNeighbourKitchenBlocks(Level level, BlockPos pos, boolean extendedUpSearch) {
        for (Direction direction : Direction.values()) {
            int upSearch = extendedUpSearch && direction == Direction.UP ? 2 : 1;
            for (int n = 1; n <= upSearch; ++n) {
                BlockPos position = pos.m_5484_(direction, n);
                if (this.checkedPos.contains(position)) continue;
                this.checkedPos.add(position);
                BlockEntity blockEntity = level.m_7702_(position);
                if (blockEntity != null) {
                    IKitchenSmeltingProvider smeltingProvider;
                    IKitchenItemProvider itemProvider = (IKitchenItemProvider)ProviderUtils.getProvider((BlockEntity)blockEntity, IKitchenItemProvider.class);
                    if (itemProvider != null) {
                        this.itemProviderList.add(itemProvider);
                    }
                    if ((smeltingProvider = (IKitchenSmeltingProvider)ProviderUtils.getProvider((BlockEntity)blockEntity, IKitchenSmeltingProvider.class)) != null) {
                        this.smeltingProviderList.add(smeltingProvider);
                    }
                    if (itemProvider == null && smeltingProvider == null && ProviderUtils.getProvider((BlockEntity)blockEntity, IKitchenConnector.class) == null) continue;
                    this.findNeighbourKitchenBlocks(level, position, true);
                    continue;
                }
                BlockState state = level.m_8055_(position);
                if (state.m_60795_() || !blockConnectors.contains(state.m_60734_())) continue;
                this.findNeighbourKitchenBlocks(level, position, false);
            }
        }
    }

    public static void registerConnectorBlock(Block block) {
        blockConnectors.add(block);
    }

    @Override
    public List<IKitchenItemProvider> getItemProviders(Inventory playerInventory) {
        ArrayList sourceInventories = Lists.newArrayList();
        sourceInventories.addAll(this.itemProviderList);
        sourceInventories.add(new DefaultKitchenItemProvider((Container)playerInventory));
        return sourceInventories;
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.m_41777_().m_41620_(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && !(restStack = (provider = iterator.next()).smeltItem(restStack)).m_41619_()) {
        }
        return restStack;
    }

    public void trySmelt(ItemStack outputItem, ItemStack inputItem, Player player, boolean stack) {
        if (inputItem.m_41619_()) {
            return;
        }
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = this.getItemProviders(player.m_150109_());
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> ItemStack.m_41656_((ItemStack)it, (ItemStack)inputItem) && count > 0, inputItem);
        for (IKitchenItemProvider itemProvider : inventories) {
            int amount;
            itemProvider.resetSimulation();
            int count2 = stack ? inputItem.m_41741_() : 1;
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate, count2, inventories, requireBucket, false);
            if (sourceItem == null) continue;
            ItemStack sourceStack = sourceItem.getSourceStack();
            ItemStack restStack = this.smeltItem(sourceStack, amount = Math.min(sourceStack.m_41613_(), count2));
            if (!restStack.m_41619_()) {
                restStack = itemProvider.returnItemStack(restStack, sourceItem);
                if (!player.m_150109_().m_36054_(restStack)) {
                    player.m_36176_(restStack, false);
                }
            }
            Balm.getNetworking().sendTo(player, (Object)new MovedToOvenMessage());
            player.f_36096_.m_38946_();
            return;
        }
    }

    @Override
    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }
}

