/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import java.util.HashSet;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.network.message.FavoriteListMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ToggleFavoriteMessage {
    private final ResourceLocation itemId;
    private final boolean favorite;

    public ToggleFavoriteMessage(ResourceLocation itemId, boolean favorite) {
        this.itemId = itemId;
        this.favorite = favorite;
    }

    public static void encode(ToggleFavoriteMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.itemId);
        buf.writeBoolean(message.favorite);
    }

    public static ToggleFavoriteMessage decode(FriendlyByteBuf buf) {
        ResourceLocation itemId = buf.m_130281_();
        boolean favorite = buf.readBoolean();
        return new ToggleFavoriteMessage(itemId, favorite);
    }

    public static void handle(ServerPlayer player, ToggleFavoriteMessage message) {
        CompoundTag data = Balm.getHooks().getPersistentData((Player)player);
        CompoundTag cfbData = data.m_128469_("CookingForBlockheads");
        CompoundTag favoriteItems = cfbData.m_128469_("FavoriteItemIds");
        if (message.favorite) {
            favoriteItems.m_128379_(message.itemId.toString(), true);
        } else {
            favoriteItems.m_128473_(message.itemId.toString());
        }
        cfbData.m_128365_("FavoriteItemIds", (Tag)favoriteItems);
        data.m_128365_("CookingForBlockheads", (Tag)cfbData);
        HashSet<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();
        for (String favoriteItemId : favoriteItems.m_128431_()) {
            favoriteItemIds.add(new ResourceLocation(favoriteItemId));
        }
        Balm.getNetworking().sendTo((Player)player, (Object)new FavoriteListMessage(favoriteItemIds));
    }
}

