/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class CuriosSlotDataComponent {
    public static final String CURIO_SLOT_TAG = "CorpseCuriosSlot";
    public static final String CURIO_SLOT_TYPE = "SlotType";
    public static final String CURIO_SLOT_INDEX = "SlotIndex";
    public static final String WAS_EQUIPPED = "WasEquipped";
    public static final String IS_COSMETIC = "IsCosmetic";

    public static CurioSlotData getCurioSlotData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return CurioSlotData.fromNBT(tag);
    }

    public static void setCurioSlotData(ItemStack stack, String slotType, int slotIndex, boolean wasEquipped, boolean isCosmetic) {
        CurioSlotData data = new CurioSlotData(slotType, slotIndex, wasEquipped, isCosmetic);
        data.writeToNBT(stack);
    }

    public static void removeCurioSlotData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(CURIO_SLOT_TAG)) {
            tag.m_128473_(CURIO_SLOT_TAG);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static class CurioSlotData {
        private final String slotType;
        private final int slotIndex;
        private final boolean wasEquipped;
        private final boolean isCosmetic;

        public CurioSlotData(String slotType, int slotIndex, boolean wasEquipped, boolean isCosmetic) {
            this.slotType = slotType;
            this.slotIndex = slotIndex;
            this.wasEquipped = wasEquipped;
            this.isCosmetic = isCosmetic;
        }

        public String slotType() {
            return this.slotType;
        }

        public int slotIndex() {
            return this.slotIndex;
        }

        public boolean wasEquipped() {
            return this.wasEquipped;
        }

        public boolean isCosmetic() {
            return this.isCosmetic;
        }

        public static CurioSlotData fromNBT(CompoundTag tag) {
            if (!tag.m_128441_(CuriosSlotDataComponent.CURIO_SLOT_TAG)) {
                return null;
            }
            CompoundTag slotData = tag.m_128469_(CuriosSlotDataComponent.CURIO_SLOT_TAG);
            return new CurioSlotData(slotData.m_128461_(CuriosSlotDataComponent.CURIO_SLOT_TYPE), slotData.m_128451_(CuriosSlotDataComponent.CURIO_SLOT_INDEX), slotData.m_128471_(CuriosSlotDataComponent.WAS_EQUIPPED), slotData.m_128471_(CuriosSlotDataComponent.IS_COSMETIC));
        }

        public void writeToNBT(ItemStack stack) {
            CompoundTag tag = stack.m_41784_();
            CompoundTag slotData = new CompoundTag();
            slotData.m_128359_(CuriosSlotDataComponent.CURIO_SLOT_TYPE, this.slotType);
            slotData.m_128405_(CuriosSlotDataComponent.CURIO_SLOT_INDEX, this.slotIndex);
            slotData.m_128379_(CuriosSlotDataComponent.WAS_EQUIPPED, this.wasEquipped);
            slotData.m_128379_(CuriosSlotDataComponent.IS_COSMETIC, this.isCosmetic);
            tag.m_128365_(CuriosSlotDataComponent.CURIO_SLOT_TAG, (Tag)slotData);
        }
    }
}

