/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block.entity;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.block.container.CrabTrapMenu;
import alabaster.crabbersdelight.common.block.entity.inventory.CrabTrapItemHandler;
import alabaster.crabbersdelight.common.registry.CDModBlockEntity;
import alabaster.crabbersdelight.common.tags.CDModTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrabTrapBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final Component CRAB_TRAP_NAME = Component.m_237115_((String)"block.crabbersdelight.crab_trap");
    private final CrabTrapItemHandler inventory = new CrabTrapItemHandler(){

        protected void onContentsChanged(int slot) {
            CrabTrapBlockEntity.this.m_6596_();
        }
    };
    private final IItemHandler input = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1);
    private final IItemHandler output = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 10);
    private final LazyOptional<IItemHandler> inputCap = LazyOptional.of(() -> this.input);
    private final LazyOptional<IItemHandler> outputCap = LazyOptional.of(() -> this.output);
    private int tickCounter = 0;

    public CrabTrapBlockEntity(BlockPos pos, BlockState state) {
        super(CDModBlockEntity.CRAB_TRAP.get(), pos, state);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handler", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("tickCounter", this.tickCounter);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("handler"));
        this.tickCounter = tag.m_128451_("tickCounter");
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public static Pair<Integer, Integer> getMinMax() {
        return Pair.of((Object)((Integer)Config.MIN_TICKS.get()), (Object)((Integer)Config.MAX_TICKS.get()));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrabTrapBlockEntity blockEntity) {
        RandomSource random = level.m_213780_();
        if ((Integer)CrabTrapBlockEntity.getMinMax().getSecond() > (Integer)CrabTrapBlockEntity.getMinMax().getFirst()) {
            if (blockEntity.tickCounter >= random.m_216332_(((Integer)CrabTrapBlockEntity.getMinMax().getFirst()).intValue(), ((Integer)CrabTrapBlockEntity.getMinMax().getSecond()).intValue())) {
                blockEntity.tickCounter = 0;
                if (CrabTrapBlockEntity.isSurroundedByWater(level, pos) && CrabTrapBlockEntity.isValidFishingLocation(level, pos)) {
                    LootParams lootparams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81462_, (Object)blockEntity).m_287235_(LootContextParamSets.f_81414_);
                    ItemStack itemInBaitSlot = blockEntity.inventory.getStackInSlot(0);
                    if (itemInBaitSlot.m_204117_(CDModTags.CRAB_TRAP_BAIT)) {
                        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemInBaitSlot.m_41720_());
                        ResourceLocation lootTableLocation = CrabbersDelight.modPrefix("gameplay/crab_trap_loot/" + Objects.requireNonNull(registryName).m_135827_() + "/" + registryName.m_135815_());
                        LootTable loottable = level.m_7654_().m_278653_().m_278676_(lootTableLocation);
                        ObjectArrayList list = loottable.m_287195_(lootparams);
                        blockEntity.inventory.addItemsAndShrinkBait(level, pos, (List<ItemStack>)list, itemInBaitSlot, random);
                    }
                }
            } else {
                if (CrabTrapBlockEntity.isWaterBiome(level, pos)) {
                    ++blockEntity.tickCounter;
                }
                ++blockEntity.tickCounter;
            }
        } else {
            CrabbersDelight.LOGGER.error("Error: Minimum value is higher than maximum value!");
        }
    }

    private static boolean isValidFishingLocation(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_) || !level.m_6425_(pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSurroundedByWater(Level level, BlockPos pos) {
        if (((Boolean)Config.REQUIRE_SURROUNDING_WATER.get()).booleanValue()) {
            for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 0, 1))) {
                if (level.m_6425_(nearbyPos).m_205070_(FluidTags.f_13131_)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean isWaterBiome(Level level, BlockPos pos) {
        return level.m_204166_(pos).m_203656_(Tags.Biomes.IS_WATER);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == Direction.UP) {
                return this.inputCap.cast();
            }
            return this.outputCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputCap.invalidate();
        this.outputCap.invalidate();
    }

    public CrabTrapItemHandler getInventory() {
        return this.inventory;
    }

    public Component m_7755_() {
        return CRAB_TRAP_NAME;
    }

    public Component m_5446_() {
        return CRAB_TRAP_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new CrabTrapMenu(id, playerInv, this.inventory);
    }
}

