/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.entity.boat;

import alabaster.crabbersdelight.common.entity.boat.CDBoatEntity;
import alabaster.crabbersdelight.common.entity.boat.CDChestBoatEntity;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class CDBoatRenderer
extends BoatRenderer {
    private final Map<CDBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(CDBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("crabbersdelight", CDBoatRenderer.getTextureLocation(type, chestBoat)), this.createBoatModel(context, (CDBoatEntity.Type)((Object)type), chestBoat))));

    public CDBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context, chestBoat);
    }

    private static String getTextureLocation(CDBoatEntity.Type type, boolean chestBoat) {
        return chestBoat ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, CDBoatEntity.Type type, boolean chestBoat) {
        ModelLayerLocation modelLayerLocation = chestBoat ? CDBoatRenderer.createChestBoatModelName(type) : CDBoatRenderer.createBoatModelName(type);
        ModelPart modelPart = context.m_174023_(modelLayerLocation);
        return chestBoat ? new ChestBoatModel(modelPart) : new BoatModel(modelPart);
    }

    public static ModelLayerLocation createBoatModelName(CDBoatEntity.Type type) {
        return CDBoatRenderer.createLocation("boat/" + type.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(CDBoatEntity.Type type) {
        return CDBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(new ResourceLocation("crabbersdelight", path), model);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof CDBoatEntity) {
            CDBoatEntity modBoat = (CDBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof CDChestBoatEntity) {
            CDChestBoatEntity modChestBoatEntity = (CDChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

