/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.handlers;

import com.nukateam.cgs.common.faundation.block.GuanoPileBlock;
import com.nukateam.cgs.common.faundation.registry.CgsBlocks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgs")
public class GuanoAccumulationHandler {
    private static final Map<BlockPos, Long> batTrackingMap = new HashMap<BlockPos, Long>();
    private static final int ACCUMULATION_TIME = 600;
    private static final double ACCUMULATION_CHANCE = 0.1;

    @SubscribeEvent
    public static void onBatUpdate(LivingEvent.LivingTickEvent event) {
        BlockPos batPos;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Bat)) {
            return;
        }
        Bat bat = (Bat)livingEntity;
        if (bat.m_9236_().f_46443_) {
            return;
        }
        Level level = bat.m_9236_();
        if (GuanoAccumulationHandler.isValidForGuanoAccumulation(bat, level, batPos = bat.m_20183_())) {
            BlockPos groundPos = GuanoAccumulationHandler.findGroundBelowBat(level, batPos);
            if (groundPos != null) {
                batTrackingMap.merge(groundPos, 1L, Long::sum);
                Long timeSpent = batTrackingMap.get(groundPos);
                if (timeSpent >= 600L) {
                    GuanoAccumulationHandler.tryAccumulateGuano(level, groundPos);
                    batTrackingMap.remove(groundPos);
                }
            }
        } else {
            batTrackingMap.entrySet().removeIf(entry -> ((BlockPos)entry.getKey()).m_203195_((Position)bat.m_20182_(), 2.0));
        }
    }

    private static boolean isValidForGuanoAccumulation(Bat bat, Level level, BlockPos pos) {
        return bat.m_27452_() && level.m_46803_(pos) < 5 && !level.m_46758_(pos);
    }

    private static BlockPos findGroundBelowBat(Level level, BlockPos batPos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos checkPos = batPos.m_6625_(i);
            BlockState state = level.m_8055_(checkPos);
            if (!state.m_60804_((BlockGetter)level, checkPos) || !Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)level, checkPos), (Direction)Direction.UP)) continue;
            return checkPos.m_7494_();
        }
        return null;
    }

    private static void tryAccumulateGuano(Level level, BlockPos pos) {
        if (level.f_46441_.m_188500_() < 0.1) {
            BlockState currentState = level.m_8055_(pos);
            if (currentState.m_60795_()) {
                level.m_7731_(pos, ((Block)CgsBlocks.GUANO_BLOCK.get()).m_49966_(), 3);
            } else if (currentState.m_60734_() instanceof GuanoPileBlock) {
                int layers = (Integer)currentState.m_61143_((Property)SnowLayerBlock.f_56581_);
                if (layers < 8) {
                    level.m_7731_(pos, (BlockState)currentState.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1)), 3);
                } else {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CgsBlocks.GUANO_BLOCK.get()));
                }
            }
        }
    }
}

