/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.faundation.item;

import com.nukateam.cgs.common.faundation.registry.items.CgsItems;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.RegistryObject;

public class FluidContainerItem
extends BucketItem {
    private final Supplier<? extends Fluid> fluidSupplier;

    public FluidContainerItem(Supplier<? extends Fluid> fluid, Item.Properties properties) {
        super(fluid, properties);
        this.fluidSupplier = fluid;
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        if (this == CgsItems.LAVA_CONTAINER.get()) {
            return 20000;
        }
        return -1;
    }

    public boolean m_41470_() {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (this.fluidSupplier.get() == Fluids.f_76191_) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)CgsItems.EMPTY_CONTAINER.get());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hitResult = FluidContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)));
        if (ret != null) {
            return ret;
        }
        BlockPos blockpos = hitResult.m_82425_();
        Direction direction = hitResult.m_82434_();
        BlockPos relative = blockpos.m_121945_(direction);
        if (level.m_7966_(player, blockpos) && player.m_36204_(relative, direction, stack)) {
            BlockPos pos = hitResult.m_82425_();
            BlockState state = level.m_8055_(pos);
            Fluid fluid = state.m_60819_().m_76152_();
            if (this.fluidSupplier.get() == Fluids.f_76191_) {
                InteractionResult pickupResult = this.tryPickupFluid(player, level, hitResult, fluid);
                if (pickupResult.m_19077_()) {
                    ItemStack container = this.handleContainerAfterUse(fluid, player, stack, true);
                    return InteractionResultHolder.m_19092_((Object)container, (boolean)level.m_5776_());
                }
            } else {
                InteractionResult placementResult = this.tryPlaceFluid(player, level, hitResult, stack);
                if (placementResult.m_19077_()) {
                    ItemStack container = this.handleContainerAfterUse(fluid, player, stack, false);
                    return InteractionResultHolder.m_19092_((Object)container, (boolean)level.m_5776_());
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private InteractionResult tryPickupFluid(Player player, Level level, BlockHitResult hitResult, Fluid stack) {
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            bucketPickup.m_142598_((LevelAccessor)level, pos, state);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            bucketPickup.getPickupSound(state).ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult tryPlaceFluid(Player player, Level level, BlockHitResult hitResult, ItemStack stack) {
        BlockPos placePos;
        BlockPos blockpos = hitResult.m_82425_();
        Direction direction = hitResult.m_82434_();
        BlockPos relativePos = blockpos.m_121945_(direction);
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos blockPos = placePos = this.canBlockContainFluid(level, blockpos, blockstate) ? blockpos : relativePos;
        if (level.m_7966_(player, blockpos) && player.m_36204_(relativePos, direction, stack)) {
            if (this.emptyContents(player, level, placePos, hitResult, stack)) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, placePos, stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result, @Nullable ItemStack container) {
        LiquidBlockContainer liquidBlockContainer;
        boolean canPlaceLiquid;
        if (!(this.fluidSupplier.get() instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        boolean canBeReplaced = blockstate.m_60722_(this.fluidSupplier.get());
        boolean bl = canPlaceLiquid = block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockstate, this.fluidSupplier.get());
        if (!(blockstate.m_60795_() || canBeReplaced || canPlaceLiquid)) {
            return result != null && this.emptyContents(player, level, result.m_82425_().m_121945_(result.m_82434_()), null, container);
        }
        if (containedFluidStack.isPresent() && this.fluidSupplier.get().getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            this.fluidSupplier.get().getFluidType().onVaporize(player, level, pos, (FluidStack)containedFluidStack.get());
            return false;
        }
        if (level.m_6042_().f_63857_() && this.fluidSupplier.get().m_205067_(FluidTags.f_13131_)) {
            float pitch = 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f;
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, pitch);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
            return false;
        }
        if (block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockstate, this.fluidSupplier.get())) {
            liquidBlockContainer.m_7361_((LevelAccessor)level, pos, blockstate, ((FlowingFluid)this.fluidSupplier.get()).m_76068_(false));
            this.m_7718_(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.f_46443_ && canBeReplaced && !blockstate.m_278721_()) {
            level.m_46961_(pos, true);
        }
        if (!level.m_7731_(pos, this.fluidSupplier.get().m_76145_().m_76188_(), 11) && !blockstate.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(player, (LevelAccessor)level, pos);
        return true;
    }

    private ItemStack handleContainerAfterUse(Fluid targetFluid, Player player, ItemStack stack, boolean filled) {
        if (!player.m_7500_()) {
            Item newContainer;
            Item item = newContainer = filled ? this.getFilledContainerForFluid(targetFluid) : (Item)CgsItems.EMPTY_CONTAINER.get();
            if (newContainer == null) {
                return stack;
            }
            ItemStack newStack = new ItemStack((ItemLike)newContainer);
            if (stack.m_41782_()) {
                newStack.m_41751_(stack.m_41783_().m_6426_());
            }
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                return newStack;
            }
            if (!player.m_150109_().m_36054_(newStack)) {
                player.m_36176_(newStack, false);
            }
            return stack;
        }
        return stack;
    }

    private Item getFilledContainerForFluid(Fluid fluid) {
        for (Map.Entry<Fluid, RegistryObject<Item>> entry : CgsItems.CONTAINERS.entrySet()) {
            if (entry.getKey() != fluid) continue;
            return (Item)entry.getValue().get();
        }
        return null;
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor level, BlockPos pPos) {
        SoundEvent soundevent = this.fluidSupplier.get().getFluidType().getSound(player, (BlockGetter)level, pPos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = this.fluidSupplier.get().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        level.m_5594_(player, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157769_, pPos);
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.fluidSupplier.get());
    }
}

