/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.cgs.common.ntgl;

import com.nukateam.cgs.Gunsmithing;
import com.nukateam.cgs.common.faundation.registry.items.CgsItems;
import com.nukateam.cgs.common.utils.GunUtils;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.CombustibleItem;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;

public class CgsAmmoHolders {
    public static AmmoHolder AIR = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("air")).isAcceptable(CgsAmmoHolders::isAir).value(s -> (int)BacktankUtil.getAir((ItemStack)s)).onConsume(CgsAmmoHolders::onConsumeAir).build();
    public static final AmmoHolder WATER = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("water")).isAcceptable(CgsAmmoHolders::isWater).value(stack -> 1000).onConsume(CgsAmmoHolders::consumeWater).build();
    public static final AmmoHolder BURNABLE = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("burnable")).isAcceptable(CgsAmmoHolders::isBurnable).value(stack -> ForgeHooks.getBurnTime((ItemStack)stack, null)).onConsume(CgsAmmoHolders::consumeBurnable).build();
    public static final AmmoHolder BLAZE_CAKE = AmmoHolder.Builder.create((ResourceLocation)Gunsmithing.cgsResource("blaze_cake")).isAcceptable(stack -> stack.m_41720_() == AllItems.BLAZE_CAKE.get()).value(stack -> 20000).descriptionId(s -> ((CombustibleItem)AllItems.BLAZE_CAKE.get()).m_5524_()).build();

    public static void register() {
        AmmoHolder.registerType((AmmoHolder)AIR);
        AmmoHolder.registerType((AmmoHolder)WATER);
        AmmoHolder.registerType((AmmoHolder)BURNABLE);
        AmmoHolder.registerType((AmmoHolder)BLAZE_CAKE);
    }

    private static Boolean isAir(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof BacktankItem && BacktankUtil.hasAirRemaining((ItemStack)stack);
    }

    public static boolean isWater(ItemStack ammoStack) {
        return ammoStack.m_41720_() == Items.f_42447_ || ammoStack.m_41720_() == CgsItems.WATER_CONTAINER.get();
    }

    private static boolean isBurnable(ItemStack ammoStack) {
        int burnTime = ForgeHooks.getBurnTime((ItemStack)ammoStack, null);
        return ammoStack.m_41720_() != AllItems.BLAZE_CAKE.get() && burnTime > 0;
    }

    private static List<ItemStack> onConsumeAir(ItemStack tank, Integer amount) {
        float tankAir = BacktankUtil.getAir((ItemStack)tank);
        ItemStack newTank = tank.m_41777_();
        GunUtils.setAir(tank, Math.max(0.0f, tankAir - (float)amount.intValue()));
        GunUtils.consumeAir(newTank, amount.intValue());
        return List.of(newTank);
    }

    public static List<ItemStack> consumeWater(ItemStack stack, Integer i) {
        if (stack.m_41720_() == Items.f_42447_) {
            return List.of(new ItemStack((ItemLike)Items.f_42446_));
        }
        if (stack.m_41720_() == CgsItems.WATER_CONTAINER.get()) {
            return List.of(new ItemStack((ItemLike)CgsItems.EMPTY_CONTAINER.get()));
        }
        return List.of();
    }

    public static List<ItemStack> consumeBurnable(ItemStack stack, Integer i) {
        if (stack.m_41720_() == Items.f_42448_) {
            return List.of(new ItemStack((ItemLike)Items.f_42446_));
        }
        if (stack.m_41720_() == CgsItems.LAVA_CONTAINER.get()) {
            return List.of(new ItemStack((ItemLike)CgsItems.EMPTY_CONTAINER.get()));
        }
        return List.of();
    }
}

