/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.motors.MotorScrollValueBehaviour;
import org.antarcticgardens.newage.content.motors.extension.MotorExtensionBlockEntity;
import org.antarcticgardens.newage.content.motors.variants.IMotorVariant;
import org.antarcticgardens.newage.energy.InsertOnlyResizableEnergyContainer;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class MotorBlockEntity
extends GeneratingKineticBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer>,
IHaveGoggleInformation {
    public boolean needsPower = false;
    public WrappedBlockEnergyContainer energy;
    private final IMotorVariant variant;
    public MotorScrollValueBehaviour speedBehavior;
    public boolean powered = false;
    private float actualSpeed = 0.0f;
    private float actualStress = 0.0f;
    private long prvEnergy = -100000L;
    private float speed = 0.0f;
    private float stress = 0.0f;
    private InsertOnlyResizableEnergyContainer mut;
    private long e;

    public MotorBlockEntity(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3, IMotorVariant variant) {
        super(arg, arg2, arg3);
        this.variant = variant;
        this.getOrCreateNetwork();
        this.getEnergyStorage();
        this.mut.setMaxCapacity(variant.getMaxCapacity());
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorBlockEntity> create(IMotorVariant variant) {
        return (type, pos, state) -> new MotorBlockEntity(type, pos, state, variant);
    }

    public void initialize() {
        this.powered = this.m_58904_().m_276867_(this.m_58899_());
        super.initialize();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.speedBehavior = new MotorScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.speedBehavior.requiresWrench();
        this.speedBehavior.value = this.getDefaultSpeed();
        this.speedBehavior.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.speedBehavior);
    }

    public int getDefaultSpeed() {
        return 16;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.energy.setEnergy(compound.m_128454_("energy"));
        this.actualSpeed = compound.m_128457_("aSpeed");
        this.needsPower = compound.m_128471_("needsPower");
        this.stress = compound.m_128457_("lastGeneratedStress");
        this.speed = compound.m_128457_("lastGeneratedSpeed");
        this.e = compound.m_128454_("eUse");
        this.actualStress = compound.m_128457_("actualStress");
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128356_("energy", this.energy.getStoredEnergy());
        compound.m_128350_("aSpeed", this.actualSpeed);
        compound.m_128379_("needsPower", this.needsPower);
        compound.m_128350_("lastGeneratedStress", this.stress);
        compound.m_128350_("lastGeneratedSpeed", this.speed);
        compound.m_128350_("eUse", (float)this.e);
        compound.m_128350_("actualStress", this.actualStress);
        super.write(compound, clientPacket);
    }

    public float calculateStressApplied() {
        return 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getStoredEnergy()), StringFormattingTool.formatLong(this.energy.getMaxCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormattingTool.formatLong(this.e)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public float calculateAddedStressCapacity() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return this.lastCapacityProvided;
        }
        this.lastCapacityProvided = this.actualStress / this.actualSpeed;
        this.lastCapacityProvided = Float.isNaN(this.lastCapacityProvided) || Float.isInfinite(this.lastCapacityProvided) ? 0.0f : Math.abs(this.lastCapacityProvided);
        return this.lastCapacityProvided;
    }

    public float getGeneratedSpeed() {
        return this.actualSpeed;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            network.updateCapacityFor((KineticBlockEntity)this, this.stress);
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        float stressMultiplier = 1.0f;
        long extraEnergy = 0L;
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        if (this.f_58857_.m_8055_(this.m_58899_().m_121945_(dir.m_122424_())).m_61145_((Property)DirectionalKineticBlock.FACING).orElse(dir.m_122424_()) == dir && (blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir.m_122424_()))) instanceof MotorExtensionBlockEntity) {
            MotorExtensionBlockEntity extension = (MotorExtensionBlockEntity)blockEntity;
            stressMultiplier = extension.getMultiplier();
            extraEnergy = extension.getVariant().getExtraCapacity();
        }
        this.mut.setMaxCapacity(extraEnergy + this.variant.getMaxCapacity());
        this.speedBehavior.betweenValidated((int)(-this.variant.getSpeed()), (int)this.variant.getSpeed());
        if (!this.f_58857_.m_5776_()) {
            int needed = (int)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)NewAgeConfig.getCommon().motorSUMultiplier.get() * (Double)NewAgeConfig.getCommon().suToEnergy.get());
            long l = this.e = this.needsPower == this.powered ? this.energy.internalExtract((long)needed, false) : 0L;
            if (this.e > 0L) {
                this.actualSpeed = this.speedBehavior.value;
                this.actualStress = (float)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)NewAgeConfig.getCommon().motorSUMultiplier.get() * (double)((float)this.e / (float)needed));
            } else {
                this.actualSpeed = 0.0f;
                this.actualStress = 0.0f;
            }
            if (this.actualSpeed != this.speed || this.actualStress != this.stress) {
                this.updateGeneratedRotation();
                this.speed = this.actualSpeed;
                this.stress = this.actualStress;
            } else if (this.energy.getStoredEnergy() != this.prvEnergy && this.f_58857_.m_46467_() % 20L == 0L) {
                this.sendData();
                this.prvEnergy = this.energy.getStoredEnergy();
            }
        }
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        WrappedBlockEnergyContainer wrappedBlockEnergyContainer;
        if (this.energy == null) {
            this.mut = new InsertOnlyResizableEnergyContainer(this.mut == null ? 1L : this.mut.getMaxCapacity());
            wrappedBlockEnergyContainer = this.energy = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)this.mut);
        } else {
            wrappedBlockEnergyContainer = this.energy;
        }
        return wrappedBlockEnergyContainer;
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

